<?php
// salvar_respostas.php
$host = "localhost";
$db   = "kaltekgo_avila";
$user = "kaltekgo_admin";
$pass = "kaltek@2024";

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die("Erro ao conectar: " . $conn->connect_error);
}
$conn->set_charset("utf8");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $idAluno       = $_POST['idAluno']       ?? null;
    $idTurma       = $_POST['idTurma']       ?? null;
    $nomeTurma     = $_POST['nomeTurma']     ?? '';
    $nomeProfessor = $_POST['nomeProfessor'] ?? '';
    $nomeAluno     = $_POST['nomeAluno']     ?? '';

    if (!$idAluno || !$idTurma) {
        die("<script>alert('❌ Dados do aluno ou turma ausentes.'); window.history.back();</script>");
    }

    $conn->begin_transaction();

    try {
        // === 1. SALVA OU ATUALIZA RESPOSTAS DAS PERGUNTAS ===
        $check = $conn->prepare("SELECT id FROM questionario_respostas WHERE idPergunta=? AND idAluno=? AND idTurma=?");
        $insert = $conn->prepare("INSERT INTO questionario_respostas (idPergunta, resposta, idAluno, idTurma, nomeTurma, nomeProfessor, nomeAluno)
                                  VALUES (?, ?, ?, ?, ?, ?, ?)");
        $update = $conn->prepare("UPDATE questionario_respostas
                                  SET resposta=?, nomeProfessor=?, nomeTurma=?, nomeAluno=?
                                  WHERE idPergunta=? AND idAluno=? AND idTurma=?");

        foreach ($_POST as $campo => $valor) {
            if (preg_match('/^p(\d+)$/', $campo, $matches)) {
                $idPergunta = (int)$matches[1];
                $resposta   = strtoupper(trim($valor));

                $check->bind_param("iii", $idPergunta, $idAluno, $idTurma);
                $check->execute();
                $res = $check->get_result();

                if ($res->num_rows > 0) {
                    // Atualiza registro existente
                    $update->bind_param("ssssiii", $resposta, $nomeProfessor, $nomeTurma, $nomeAluno, $idPergunta, $idAluno, $idTurma);
                    $update->execute();
                } else {
                    // Insere novo registro
                    $insert->bind_param("isissss", $idPergunta, $resposta, $idAluno, $idTurma, $nomeTurma, $nomeProfessor, $nomeAluno);
                    $insert->execute();
                }
            }
        }

        // === 2. SALVA OU ATUALIZA OBSERVAÇÕES ===
        $comportamentos    = $_POST['comportamentos'] ?? '';
        $aspecto_cognitivo = $_POST['aspecto_cognitivo'] ?? '';
        $raciocinio_logico = $_POST['raciocinio_logico'] ?? '';
        $consideracoes     = $_POST['consideracoes'] ?? '';

        $checkObs = $conn->prepare("SELECT id FROM questionario_observacoes WHERE idAluno=? AND idTurma=?");
        $checkObs->bind_param("ii", $idAluno, $idTurma);
        $checkObs->execute();
        $resObs = $checkObs->get_result();

        if ($resObs->num_rows > 0) {
            // UPDATE se já existir
            $stmtObs = $conn->prepare("
                UPDATE questionario_observacoes 
                SET comportamentos=?, aspecto_cognitivo=?, raciocinio_logico=?, consideracoes=?, 
                    nomeTurma=?, nomeProfessor=?, nomeAluno=?, data_registro=NOW()
                WHERE idAluno=? AND idTurma=?
            ");
            $stmtObs->bind_param(
                "sssssssii",
                $comportamentos, $aspecto_cognitivo, $raciocinio_logico, $consideracoes,
                $nomeTurma, $nomeProfessor, $nomeAluno, $idAluno, $idTurma
            );
        } else {
            // INSERT se for novo
            $stmtObs = $conn->prepare("
                INSERT INTO questionario_observacoes 
                (idAluno, idTurma, nomeTurma, nomeProfessor, nomeAluno, comportamentos, aspecto_cognitivo, raciocinio_logico, consideracoes, data_registro)
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())
            ");
            $stmtObs->bind_param(
                "iisssssss",
                $idAluno, $idTurma, $nomeTurma, $nomeProfessor, $nomeAluno,
                $comportamentos, $aspecto_cognitivo, $raciocinio_logico, $consideracoes
            );
        }
        $stmtObs->execute();

        $conn->commit();
        echo "<script>alert('✅ Respostas atualizadas com sucesso!'); window.location='questionario.php';</script>";

    } catch (Exception $e) {
        $conn->rollback();
        echo "<script>alert('❌ Erro ao salvar: " . addslashes($e->getMessage()) . "'); window.history.back();</script>";
    }
} else {
    echo "<script>alert('Acesso inválido.'); window.location='index.php';</script>";
}

$conn->close();
?>
