<?php
// listar_alunos.php
// Configuração de conexão
$host = "localhost";
$db   = "kaltekgo_avila";
$user = "kaltekgo_admin";
$pass = "kaltek@2024";

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die("Erro ao conectar: " . $conn->connect_error);
}
$conn->set_charset("utf8");

// Busca todas as turmas disponíveis
$sqlTurmas = "SELECT DISTINCT identificadorturma FROM alunos_confirmados_2025 ORDER BY identificadorturma ASC";
$turmas = $conn->query($sqlTurmas);

$turmaSelecionada = isset($_GET['turma']) ? $conn->real_escape_string($_GET['turma']) : "";

// Se for requisição AJAX (carregar apenas alunos)
if (isset($_GET['ajax']) && $_GET['ajax'] == "1" && $turmaSelecionada != "") {
    listarAlunos($conn, $turmaSelecionada);
    exit;
}

// Função para listar alunos (para uso no corpo da página e no AJAX)
function listarAlunos($conn, $turma) {
    $sql = "SELECT matricula, nome, identificadorturma 
            FROM alunos_confirmados_2025 
            WHERE identificadorturma = '$turma' 
            ORDER BY nome ASC";
    $res = $conn->query($sql);

    if ($res && $res->num_rows > 0) {
        while ($row = $res->fetch_assoc()) {
            $matricula = $row['matricula'];
            $sqlCheck = "
                SELECT 1 FROM questionario_respostas WHERE idAluno = '$matricula'
                UNION
                SELECT 1 FROM questionario_observacoes WHERE idAluno = '$matricula'
                LIMIT 1
            ";
            $jaPreencheu = $conn->query($sqlCheck)->num_rows > 0;

            echo "<tr>
                    <td>" . htmlspecialchars($matricula) . "</td>
                    <td>" . htmlspecialchars($row['nome']) . "</td>
                    <td>" . htmlspecialchars($row['identificadorturma']) . "</td>
                    <td class='text-center'>";
            if ($jaPreencheu) {
                echo "<a href='index.php?matricula=" . urlencode($matricula) . "&&nome=" . urlencode($row['nome']) . "&&turma=" . urlencode($row['identificadorturma']) . "' 
                        class='btn btn-editar btn-sm'>📝 Editar Questionário</a>";
            } else {
                echo "<a href='index.php?matricula=" . urlencode($matricula) . "&&nome=" . urlencode($row['nome']) . "&&turma=" . urlencode($row['identificadorturma']) . "' 
                        class='btn btn-questionario btn-sm'>📝 Preencher Questionário</a>";
            }
            echo "</td></tr>";
        }
    } else {
        echo "<tr><td colspan='4' class='text-center text-muted'>Nenhum aluno encontrado.</td></tr>";
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<title>Alunos Confirmados 2025</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

<style>
body {
    font-family: Arial, sans-serif;
    background: #f9f9f9;
    margin: 20px;
}
.table {
    background: #fff;
    border: 1px solid #ccc;
}
th {
    background: #000;
    color: #fff;
    text-transform: uppercase;
}
td, th {
    font-size: 13px;
}
.btn-questionario {
    background-color: #007bff;
    color: #fff;
    border: none;
    padding: 5px 10px;
    border-radius: 4px;
}
.btn-editar {
    background-color: #28a745;
    color: #fff;
    border: none;
    padding: 5px 10px;
    border-radius: 4px;
}
.btn-questionario:hover {
    background-color: #0056b3;
}
.btn-editar:hover {
    background-color: #1e7e34;
}
</style>

<script>
$(document).ready(function(){
    // Quando muda a turma no select
    $("#turmaSelect").change(function(){
        var turma = $(this).val();
        if (turma !== "") {
            history.replaceState(null, "", "?turma=" + encodeURIComponent(turma)); // Atualiza URL
            $.get("listar_alunos.php", { ajax: 1, turma: turma }, function(data){
                $("#tbodyAlunos").html(data);
            });
        } else {
            history.replaceState(null, "", "listar_alunos.php"); // limpa URL
            $("#tbodyAlunos").html("<tr><td colspan='4' class='text-center text-muted'>Selecione uma turma acima.</td></tr>");
        }
    });

    // Se já tiver turma na URL, carregar automaticamente
    <?php if ($turmaSelecionada != ""): ?>
        $.get("listar_alunos.php", { ajax: 1, turma: "<?= $turmaSelecionada ?>" }, function(data){
            $("#tbodyAlunos").html(data);
        });
    <?php endif; ?>
});
</script>
</head>
<body>

<div class="container">
    <h3 class="text-center" style="margin-bottom:25px;">📋 Lista de Alunos Confirmados 2025</h3>

    <div class="form-group text-center">
        <label for="turmaSelect"><strong>Selecione a Turma:</strong></label>
        <select id="turmaSelect" class="form-control" style="max-width:400px; margin:0 auto;">
            <option value="">-- Escolha uma Turma --</option>
            <?php while ($t = $turmas->fetch_assoc()): ?>
                <option value="<?= htmlspecialchars($t['identificadorturma']) ?>" 
                    <?= ($turmaSelecionada == $t['identificadorturma']) ? 'selected' : '' ?>>
                    <?= htmlspecialchars($t['identificadorturma']) ?>
                </option>
            <?php endwhile; ?>
        </select>
    </div>

    <div class="table-responsive">
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>Matrícula</th>
                    <th>Nome</th>
                    <th>Turma</th>
                    <th class="text-center">Ações</th>
                </tr>
            </thead>
            <tbody id="tbodyAlunos">
                <?php if ($turmaSelecionada == ""): ?>
                    <tr>
                        <td colspan="4" class="text-center text-muted">Selecione uma turma acima.</td>
                    </tr>
                <?php else: ?>
                    <?php listarAlunos($conn, $turmaSelecionada); ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

</body>
</html>
