<?php 

$servername = "localhost";
$username = "kaltekgo_admin";
$password = "kaltek@2024";
$database = "kaltekgo_avila";

// Criando a conexão
$conn = new mysqli($servername, $username, $password, $database);

// Verificando conexão
if ($conn->connect_error) {
    die("Erro de conexão: " . $conn->connect_error);
}

// Consulta SQL
$sql = "SELECT * FROM reuniaoAtiva WHERE ativa ='S'";
$result = $conn->query($sql);

// Verificando se há resultados
if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $tipoReuniao = htmlspecialchars($row['nomeReuniao']);
} else {
    $tipoReuniao = "Nenhuma reunião ativa encontrada";
}

// Fechando conexão
$conn->close();
?>


<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registro de Presença</title>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <style>
        body { font-family: Arial, sans-serif; text-align: center; }
        input { padding: 8px; width: 90%; max-width: 1195px; }
        @media (max-width: 768px) { input { max-width: 350px; } }
        .tabela-container { width: 90%; margin: auto; overflow-x: auto; margin-top: 20px; display: none; }
        table { width: 100%; border-collapse: collapse; text-transform: uppercase; min-width: 750px; }
        th, td { border: 1px solid black; padding: 10px; text-align: left; font-size: 12px; }
        th { background-color: #f2f2f2; }
        .botao-salvar { padding: 5px 10px; font-size: 12px; border: none; background-color: #007bff; color: white; cursor: pointer; border-radius: 5px; }
        .botao-salvar:hover { background-color: #0056b3; }
        .radio-container { display: flex; gap: 15px; align-items: center; justify-content: center; }
        .radio-container label { display: flex; align-items: center; gap: 5px; }
    </style>
</head>
<body>
    <h2 style="text-transform: uppercase;"><?php echo $tipoReuniao; ?></h2>
    <input type="text" id="busca" placeholder="Digite o nome do aluno...">
    <br><br>

    <form class="form-presenca">
        <div class="tabela-container" id="tabela-container">
            <table>
                <thead>
                    <tr>
                        <th>Nome Aluno</th>
                        <th>Turma</th>
                        <th>Nome Pai</th>
                        <th>Nome Mãe</th>
                        <th>Presença</th>
                        <th>Ação</th>
                    </tr>
                </thead>
                <tbody id="resultado"></tbody>
            </table>
        </div>
        <input type="hidden" name="reuniao" value="<?php echo $tipoReuniao; ?>">
    </form>

    <script>
        $(document).ready(function() {
            $("#busca").keyup(function() {
                var nome = $(this).val();
                if (nome.length > 1) {
                    $.post("buscar.php", { nome: nome }, function(data) {
                        if (data.trim() !== "") {
                            $("#resultado").html(data);
                            $("#tabela-container").fadeIn();
                        } else {
                            $("#resultado").html("");
                            $("#tabela-container").fadeOut();
                        }
                    });
                } else {
                    $("#resultado").html("");
                    $("#tabela-container").fadeOut();
                }
            });

            // Captura o evento de submit do formulário dinâmico
            $(document).on("submit", ".form-presenca", function(e) {
                e.preventDefault(); // Previne o envio normal do formulário

                var form = $(this);
                $.ajax({
                    type: "POST",
                    url: "salvar_presenca.php",
                    data: form.serialize(), // Envia os dados corretamente
                    success: function(response) {
                        alert("Presença registrada com sucesso!");
                        window.location.href = 'index.php'; // Redireciona para index.php após salvar
                    },
                    error: function() {
                        alert("Já registrado.");
                    }
                });
            });
        });
    </script>
</body>
</html>
