<?php
// Conexão com o banco
$host = 'localhost';
$db = 'kaltekgo_avila';
$user = 'kaltekgo_admin';
$pass = 'kaltek@2024';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (Exception $e) {
    die("Erro ao conectar: " . $e->getMessage());
}

// Pega o id_turma do GET ou POST
$id_turma = $_GET['id_turma'] ?? '';

// Busca alunos se o id_turma estiver definido
$alunos = [];
if (!empty($id_turma)) {
    $stmt = $pdo->prepare("SELECT matricula, turma, nome FROM alunos_fundamental1 WHERE id_turma = ? ORDER BY nome ASC");
    $stmt->execute([$id_turma]);
    $alunos = $stmt->fetchAll(PDO::FETCH_ASSOC);
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Alunos da Turma</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
</head>
<style>
    body {
      font-family: Arial, sans-serif;
      background-color: #ffffff;
      margin: 20px;
      color: #000000;
    }
    .topo-logo {
  display: flex;
  align-items: flex-start;
  gap: 20px;
  margin-bottom: 50px;
}

.topo-logo img {
  max-width: 200px;
  height: auto;
  position: absolute;
  margin-left: 1100px;
  margin-top:50px;
}

.info-topo {
  flex: 1;
}

    .container-fluid {
      width: 100%;
    }

    h4, h5 {
      margin: 0 0 10px;
    }

    .btn-cadastrar, .filtro-btns {
      margin-left: 15px;
      margin-bottom: 10px;
    }

    .table-responsive-custom {
      overflow-x: auto;
      -webkit-overflow-scrolling: touch;
      margin: 0 15px 20px 15px;
      display: block;
    }

    .table-scroll-top {
      overflow-x: auto;
      overflow-y: hidden;
      height: 20px;
      margin: 0 15px 5px 15px;
    }

    .table-scroll-top::-webkit-scrollbar {
      height: 8px;
    }

    .table-scroll-top::-webkit-scrollbar-thumb {
      background-color: #888;
      border-radius: 4px;
    }

    table {
      white-space: nowrap;
      width: 100%;
      border-collapse: collapse;
      background-color: #ffffff;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
      text-transform: uppercase;
      min-width: 700px;
    }

    th, td {
      padding: 12px 15px;
      text-align: left;
      font-size: 12px;
      border: 1px solid #000;
      vertical-align: middle !important;
    }

    th {
      background-color: #000;
      color: #fff;
    }

    tr:nth-child(even) {
      background-color: #f4f4f4;
    }

    tr:hover {
      background-color: #e0e0e0;
    }

    .mensagem-erro {
      color: red;
      font-size: 11px;
      margin-top: 4px;
      display: none;
    }

    .input-error {
      border: 2px solid red !important;
      background-color: #ffe6e6;
    }
    .input-vermelho {
      color: red;
    }
    .header-bar {
            width: 100%;
            padding: 10px;
            background: #f5f5f5;
            border-bottom: 1px solid #ddd;
            position: fixed;
            top: 0;
            right: 0;
            left: 0;
            z-index: 1000;
        }
        .header-bar .header-content {
            display: flex;
            justify-content: flex-end;
            align-items: center;
        }
        .header-bar .welcome {
            font-size: 12px;
            font-weight: bold;
            margin-right: 10px;
        }
        .header-bar .btn {
            margin-left: 5px;
        }
        .container {
            padding-top: 10px; /* espaço pro header fixo */
        }

    @media (max-width: 768px) {
      .btn-cadastrar, .filtro-btns .btn {
        width: 100% !important;
        margin: 10px auto;
        font-size: 16px;
        height: 45px;
        padding: 10px 12px;
      }

      .form-group label,
      .form-control {
        font-size: 14px;
      }

      .form-control,
      input[type="text"],
      select {
        height: 40px;
      }

      .table-responsive-custom {
        overflow-x: auto;
        display: block;
      }

      table {
        width: 1000px;
      }

      .table th, .table td {
        min-width: 125px;
        font-size: 14px;
        padding: 8px 10px;
      }

      h4 {
        text-align: center;
      }
    }
    
  </style>
<body class="container">
    <h2>Alunos da Turma</h2>

    <form method="GET" class="form-inline">
        <div class="form-group">
            <label for="id_turma">Selecione a Turma:</label>
            <select name="id_turma" id="id_turma" class="form-control" onchange="this.form.submit()">
                <option value="">-- Escolha uma série--</option>
                <option value="19" <?= $id_turma == '19' ? 'selected' : '' ?>>2º Ano - A</option>
                <option value="20" <?= $id_turma == '20' ? 'selected' : '' ?>>2º Ano - B</option>
                <option value="21" <?= $id_turma == '21' ? 'selected' : '' ?>>2º Ano - C</option>
                <option value="22" <?= $id_turma == '22' ? 'selected' : '' ?>>2º Ano - D</option>
                <option value="23" <?= $id_turma == '23' ? 'selected' : '' ?>>3º Ano - A</option>
                <option value="24" <?= $id_turma == '24' ? 'selected' : '' ?>>3º Ano - B</option>
                <option value="25" <?= $id_turma == '25' ? 'selected' : '' ?>>3º Ano - C</option>
                <option value="27" <?= $id_turma == '27' ? 'selected' : '' ?>>4º Ano - A</option>
                <option value="28" <?= $id_turma == '28' ? 'selected' : '' ?>>4º Ano - B</option>
                <option value="29" <?= $id_turma == '29' ? 'selected' : '' ?>>4º Ano - C</option>
                <option value="31" <?= $id_turma == '31' ? 'selected' : '' ?>>5º Ano - A</option>
                <option value="32" <?= $id_turma == '32' ? 'selected' : '' ?>>5º Ano - B</option>
                <option value="33" <?= $id_turma == '33' ? 'selected' : '' ?>>5º Ano - C</option>
                <!-- Adicione mais turmas conforme o seu banco -->
            </select>
        </div>
    </form>
<br>
    <?php if (!empty($alunos)): ?>
        <form method="POST" action="salvar_notas.php">
            <input type="hidden" name="id_turma" value="<?= htmlspecialchars($id_turma) ?>">
            
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Matrícula</th>
                        <th>Turma</th>
                        <th>Nome</th>
                        <th>Nota</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($alunos as $aluno): ?>
                        <tr>
                            <td><?= htmlspecialchars($aluno['matricula']) ?></td>
                            <td><?= htmlspecialchars($aluno['turma']) ?></td>
                            <td><?= htmlspecialchars($aluno['nome']) ?></td>
                            <td>
                                <input type="hidden" name="matricula[]" value="<?= htmlspecialchars($aluno['matricula']) ?>">
                                <input 
    type="text" 
    name="nota[]" 
    class="form-control" 
    inputmode="decimal" 
    pattern="^\d{1,2},\d{1,2}$|^\d{1,2}$"
    placeholder="Ex: 8,5" 
    required
    
>

                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>

            <button type="submit" class="btn btn-success">Salvar Notas</button>
        </form>
    <?php elseif (!empty($id_turma)): ?>
        <div class="alert alert-warning">Nenhum aluno encontrado para esta turma.</div>
    <?php endif; ?>
</body>
</html>
