<?php
header('Content-Type: application/json');

try {
    $pdo = new PDO("mysql:host=localhost;dbname=kaltekgo_avila", "kaltekgo_admin", "kaltek@2024");
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $alunos = $_POST['aluno_id'] ?? [];
    $tarefas = $_POST['tarefa'] ?? [];
    $sala = $_POST['sala'] ?? [];
    $nomes = $_POST['nome'] ?? [];
    $turmas = $_POST['id_turma'] ?? [];

    $check = $pdo->prepare("SELECT COUNT(*) FROM P3 WHERE matricula = ?");
    $update = $pdo->prepare("UPDATE P3 SET NT = ?, NS = ? WHERE matricula = ?");
    $insert = $pdo->prepare("INSERT INTO P3 (matricula, NT, NS, nome, id_turma) VALUES (?, ?, ?, ?, ?)");

    for ($i = 0; $i < count($alunos); $i++) {
        $alunoId = $alunos[$i];
        $nt = floatval(str_replace(',', '.', $tarefas[$i]));
        $ns = floatval(str_replace(',', '.', $sala[$i]));
        $nome = $nomes[$i];
        $turma = $turmas[$i];

        if ($nt !== 0.0 || $ns !== 0.0) {
            $check->execute([$alunoId]);
            $existe = $check->fetchColumn();

            if ($existe) {
                $update->execute([$nt, $ns, $alunoId]);
            } else {
                $insert->execute([$alunoId, $nt, $ns, $nome, $turma]);
            }
        }
    }

    echo json_encode(['sucesso' => true, 'mensagem' => 'Dados salvos com sucesso! Aguarde um momento']);
} catch (Exception $e) {
    echo json_encode(['sucesso' => false, 'mensagem' => 'Erro: ' . $e->getMessage()]);
}
