<?php
$pdo = new PDO("mysql:host=localhost;dbname=kaltekgo_avila", "kaltekgo_admin", "kaltek@2024");

$id_turma = $_GET['id_turma'] ?? '';
$id_disciplina = $_GET['id_disciplina'] ?? '';


function formatarNota($valor) {
    return (fmod($valor, 1) == 0.0) ? number_format($valor, 1, ',', '') : number_format($valor, 2, ',', '');
}

if ($id_turma && $id_disciplina) {
    $alunos = $pdo->prepare("
        SELECT 
            nota_tarefas_entregues.t1, 
            nota_tarefas_entregues.t2, 
            nota_tarefas_entregues.t3,
            nota_tarefas_entregues.t4,
            nota_tarefas_entregues.t5,
            nota_tarefas_entregues.t6, 
            nota_tarefas_entregues.t7, 
            nota_tarefas_entregues.t8,
            nota_tarefas_entregues.t9,
            nota_tarefas_entregues.t10,
            nota_tarefas_entregues.point1,
            nota_tarefas_entregues.point2,
            nota_tarefas_entregues.point3,
            nota_tarefas_entregues.point4,
            simulado_geral.nome, 
            simulado_geral.matricula, 
            simulado_geral.nota,
            simulado_geral.id_turma
        FROM simulado_geral
        LEFT JOIN nota_tarefas_entregues 
            ON simulado_geral.matricula = nota_tarefas_entregues.matricula
            AND nota_tarefas_entregues.id_turma = ?
            AND nota_tarefas_entregues.id_disciplina = ?
        WHERE simulado_geral.id_turma = ?
    ");
    $alunos->execute([$id_turma, $id_disciplina, $id_turma]);
    $alunos = $alunos->fetchAll(PDO::FETCH_ASSOC);
}


    foreach ($alunos as $aluno): 
        $t1 = floatval($aluno['t1']);
        $t2 = floatval($aluno['t2']);
        $t3 = floatval($aluno['t3']);
        $t4 = floatval($aluno['t4']);
        $t5 = floatval($aluno['t5']);
        $t6 = floatval($aluno['t6']);
        $t7 = floatval($aluno['t7']);
        $t8 = floatval($aluno['t8']);
        $t9 = floatval($aluno['t9']);
        $t10 = floatval($aluno['t10']);
        $simulado = floatval($aluno['nota']*0.2);
        $point = floatval(($aluno['point1']+$aluno['point2']+$aluno['point3']+$aluno['point4'])/4);
        $mt = floatval(($aluno['t1']+$aluno['t2']+$aluno['t3']+$aluno['t4']+$aluno['t5']+$aluno['t6']+$aluno['t7']+$aluno['t8']+$aluno['t9']+$aluno['t10'])/10);
        $mtotal = (($point+$mt)/2)*0.8;
        $p3 = $mtotal+$simulado;
        
        ?>
        <tr>
            <td style="width: 50px;"><strong><?= htmlspecialchars($aluno['matricula']) ?></strong>
                <input type="hidden" name="aluno_id[]" value="<?= $aluno['matricula'] ?>">
                <input type="hidden" name="id_turma[]" value="<?= $aluno['id_turma'] ?>">
                <input type="hidden" name="disciplina[]" value="<?php echo $id_disciplina; ?>">
            </td>
            <td><strong><?= htmlspecialchars($aluno['nome']) ?></strong>
                <input type="hidden" name="nome[]" value="<?= $aluno['nome'] ?>">
            </td>
            <td><input type="text" name="mt[]" class="form-control campo" value="<?= formatarNota($mtotal) ?>" min="0" max="10" step="0.1" readonly></td>
            <td><input type="text" name="point[]" class="form-control campo" value="<?= formatarNota($simulado) ?>" min="0" max="10" step="0.1" readonly></td>
            <td><input type="text" name="mtotal[]" class="form-control campo <?= $t1 < 7 ? 'input-vermelho' : '' ?>" value="<?= formatarNota($p3) ?>" min="0" max="10" step="0.1" readonly></td>
        </tr>
    <?php endforeach;

?>

</script>
