<?php
session_start();
$pdo = new PDO("mysql:host=localhost;dbname=kaltekgo_avila", "kaltekgo_admin", "kaltek@2024");

$id_professor = $_SESSION['idProfessor'] ?? null;
$nome_professor = $_SESSION['nomeProfessor'] ?? null;

$id_turma = $_GET['id_turma'] ?? null;

if ($id_professor) {
    // Buscar turmas do professor
    $turmas = $pdo->prepare("
        SELECT DISTINCT stt.* 
        FROM serie_turma_turno stt
        INNER JOIN disciplinaProfessor dp ON stt.id_serie_turma = dp.id_turma
        WHERE dp.id_professor = ?
    ");
    $turmas->execute([$id_professor]);
    $turmas = $turmas->fetchAll(PDO::FETCH_ASSOC);

    // Buscar disciplinas do professor filtradas pela turma, se fornecida
    if ($id_turma) {
        $disciplinas = $pdo->prepare("
            SELECT d.id_disciplina, d.nomeDisciplina
            FROM disciplinas d
            INNER JOIN disciplinaProfessor dp ON d.id_disciplina = dp.id_disciplina
            WHERE dp.id_professor = ? AND dp.id_turma = ?
        ");
        $disciplinas->execute([$id_professor, $id_turma]);
    } else {
        $disciplinas = $pdo->prepare("
            SELECT d.id_disciplina, d.nomeDisciplina
            FROM disciplinas d
            INNER JOIN disciplinaProfessor dp ON d.id_disciplina = dp.id_disciplina
            WHERE dp.id_professor = ?
        ");
        $disciplinas->execute([$id_professor]);
    }

    $disciplinas = $disciplinas->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'turmas' => $turmas,
        'disciplinas' => $disciplinas
    ]);
} else {
    echo json_encode(['erro' => 'Professor não autenticado']);
}
