<?php
// Configuração do banco de dados
$host = 'localhost';
$dbname = 'kaltekgo_avila';
$username = 'kaltekgo_admin';
$password = 'kaltek@2024';

// Conexão com o banco de dados
$conn = new mysqli($host, $username, $password, $dbname);

// Verificar a conexão
if ($conn->connect_error) {
    die("Erro ao conectar ao banco de dados: " . $conn->connect_error);
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Consulta Individual</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
    body {
      font-family: Arial, sans-serif;
      background-color: #ffffff;
      margin: 20px;
      color: #000000;
    }
    .topo-logo {
  display: flex;
  align-items: flex-start;
  gap: 20px;
  margin-bottom: 50px;
}

.topo-logo img {
  max-width: 200px;
  height: auto;
  position: absolute;
  margin-left: 1100px;
  margin-top:50px;
}

.info-topo {
  flex: 1;
}

    .container-fluid {
      width: 100%;
    }

    h4, h5 {
      margin: 0 0 10px;
    }

    .btn-cadastrar, .filtro-btns {
      margin-left: 15px;
      margin-bottom: 10px;
    }

    .table-responsive-custom {
      overflow-x: auto;
      -webkit-overflow-scrolling: touch;
      margin: 0 15px 20px 15px;
      display: block;
    }

    .table-scroll-top {
      overflow-x: auto;
      overflow-y: hidden;
      height: 20px;
      margin: 0 15px 5px 15px;
    }

    .table-scroll-top::-webkit-scrollbar {
      height: 8px;
    }

    .table-scroll-top::-webkit-scrollbar-thumb {
      background-color: #888;
      border-radius: 4px;
    }

    table {
      white-space: nowrap;
      width: 100%;
      border-collapse: collapse;
      background-color: #ffffff;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
      text-transform: uppercase;
      min-width: 700px;
    }

    th, td {
      padding: 12px 15px;
      text-align: left;
      font-size: 12px;
      border: 1px solid #000;
      vertical-align: middle !important;
    }

    th {
      background-color: #000;
      color: #fff;
    }

    tr:nth-child(even) {
      background-color: #f4f4f4;
    }

    tr:hover {
      background-color: #e0e0e0;
    }

    .mensagem-erro {
      color: red;
      font-size: 11px;
      margin-top: 4px;
      display: none;
    }

    .input-error {
      border: 2px solid red !important;
      background-color: #ffe6e6;
    }
    .input-vermelho {
      color: red;
    }
    .header-bar {
            width: 100%;
            padding: 10px;
            background: #f5f5f5;
            border-bottom: 1px solid #ddd;
            position: fixed;
            top: 0;
            right: 0;
            left: 0;
            z-index: 1000;
        }
        .header-bar .header-content {
            display: flex;
            justify-content: flex-end;
            align-items: center;
        }
        .header-bar .welcome {
            font-size: 12px;
            font-weight: bold;
            margin-right: 10px;
        }
        .header-bar .btn {
            margin-left: 5px;
        }
        .container {
            padding-top: 10px; /* espaço pro header fixo */
        }

    @media (max-width: 768px) {
      .btn-cadastrar, .filtro-btns .btn {
        width: 100% !important;
        margin: 10px auto;
        font-size: 16px;
        height: 45px;
        padding: 10px 12px;
      }

      .form-group label,
      .form-control {
        font-size: 14px;
      }

      .form-control,
      input[type="text"],
      select {
        height: 40px;
      }

      .table-responsive-custom {
        overflow-x: auto;
        display: block;
      }

      table {
        width: 1000px;
      }

      .table th, .table td {
        min-width: 125px;
        font-size: 14px;
        padding: 8px 10px;
      }

      h4 {
        text-align: center;
      }
    }
    
  </style>
</head>
<body>
<div class="container mt-5">
    <h2 class="mb-4">Consultar Individual</h2>

    <!-- Campo de busca -->
    <input type="text" id="campo-busca" class="form-control" placeholder="Digite para o nome do aluno...">

    <!-- Área para exibir os resultados -->
    <div id="resultados" class="mt-4">
        <!-- Resultados da busca serão carregados aqui -->
    </div>
</div>

<script>
    $(document).ready(function () {
        $('#campo-busca').on('keyup', function () {
            const query = $(this).val();

            if (query.length > 0) {
                $.ajax({
                    url: 'buscar.php',
                    type: 'GET',
                    data: { busca: query },
                    success: function (response) {
                        $('#resultados').html(response);
                    },
                    error: function () {
                        $('#resultados').html('<p class="text-danger">Erro ao buscar resultados.</p>');
                    }
                });
            } else {
                $('#resultados').html('');
            }
        });
    });
</script>

<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
