<?php
// Configuração do banco de dados
$host = 'localhost';
$dbname = 'kaltekgo_avila';
$username = 'kaltekgo_admin';
$password = 'kaltek@2024';

// Conexão com o banco de dados
$conn = new mysqli($host, $username, $password, $dbname);

// Verificar a conexão
if ($conn->connect_error) {
    die("Erro ao conectar ao banco de dados: " . $conn->connect_error);
}

// Verificar se há um parâmetro de busca
if (isset($_GET['busca']) && !empty($_GET['busca'])) {
    $busca = $conn->real_escape_string($_GET['busca']);

    // Consulta para buscar dados
    $sql = "SELECT 
    matricula,
    nome,
    turma,
    desempenho,
    nota,
    nota_saeca
FROM 
    alunos_fundamental1
WHERE 
    (nome  LIKE '%$busca%' 
     OR turma LIKE '%$busca%')
    AND id_turma BETWEEN 19 AND 33
ORDER BY 
    nome ASC;";
    $result = $conn->query($sql);

    // Exibir resultados
    if ($result->num_rows > 0) {
        echo '<table class="table table-bordered table-striped">';
        echo '<thead class="thead-dark"><tr><th>Matrícula</th><th>Nome</th><th>Turma</th><th>Nota(Obitida)</th><th>Nota(Considerada)</th></tr></thead><tbody>';

        while ($row = $result->fetch_assoc()) {
            echo '<tr>';
            echo '<td>' . htmlspecialchars($row['matricula']) . '</td>';
            echo '<td>' . htmlspecialchars($row['nome']) . '</td>';
            echo '<td>' . htmlspecialchars($row['turma']) . '</td>';
            echo '<td>' . number_format($row['nota_saeca'], 2, ',', '') . '</td>';
            echo '<td>' . number_format($row['nota_saeca'], 2, ',', '') . '</td>';
            echo '</tr>';
        }

        echo '</tbody></table>';
    } else {
        echo '<p class="text-warning">Nenhum resultado encontrado.</p>';
    }
} else {
    echo '<p class="text-danger">Parâmetro de busca inválido.</p>';
}
