<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Buscar Notas - AJAX</title>

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <!-- JQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Bootstrap JS -->
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

    <style>
        body {
            font-family: Arial;
            background-color: #fff;
            margin: 20px;
            color: #000;
        }
        table {
            white-space: nowrap;
            border-collapse: collapse;
            width: 100%;
            background: #fff;
            text-transform: uppercase;
        }
        th, td {
            border: 1px solid #000;
            padding: 8px 12px;
            text-align: center;
        }
        th {
            background: #000;
            color: #fff;
            cursor: pointer;
        }
        tr:nth-child(even) {
            background: #f4f4f4;
        }
        tr:hover {
            background: #e0e0e0;
        }
    </style>
</head>

<body class="container">

<h2 class="text-center">Buscar Notas dos Alunos</h2>

<div class="form-group">
    <input type="text" id="busca" class="form-control" placeholder="Digite o nome do aluno">
</div>

<div id="resultado"></div>

<!-- Modal -->
<div class="modal fade" id="modalNT" tabindex="-1" role="dialog" aria-labelledby="modalNTLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title" id="modalNTLabel">Informações da Tarefa</h4>
      </div>
      
      <div class="modal-body" id="conteudoModalNT">
        Carregando informações...
      </div>
      
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
      </div>
      
    </div>
  </div>
</div>

<script>
$(document).ready(function(){

    $('#busca').on('input', function(){
        const nome = $(this).val();
        if(nome.length > 0){
            $.ajax({
                url: 'buscar-individual-aluno.php',
                method: 'GET',
                data: {nome: nome},
                dataType: 'json',
                success: function(data){
                    gerarTabela(data);
                },
                error: function(){
                    $('#resultado').html('<div class="alert alert-danger">Erro ao buscar dados.</div>');
                }
            });
        } else {
            $('#resultado').html('');
        }
    });

    function gerarTabela(dados){
        $('#resultado').html('');

        if(dados.length === 0){
            $('#resultado').html('<div class="alert alert-warning">Nenhum resultado encontrado</div>');
            return;
        }

        dados.forEach(aluno => {
            let html = `<h4>Aluno: <strong>${aluno.nome}</strong> | Matrícula: <strong>${aluno.matricula}</strong> | Turma: <strong>${aluno.turma}</strong></h4>`;

            aluno.disciplinas.forEach(disc => {
                const colunas = Object.keys(disc.notas).sort();
                html += `<table class="table table-bordered"><thead>`;
                html += `<tr><th colspan="${colunas.length + 1}" class="text-center">${disc.disciplina}</th></tr>`;

                html += `<tr>`;
                colunas.forEach(col => {
                    const titulo = col.replace('t', 'NT').toUpperCase();
                    html += `<th data-coluna="${col}" data-turma="${aluno.turma}" data-disciplina="${disc.disciplina}">${titulo}</th>`;
                });
                html += `<th>MT</th>`;
                html += `</tr></thead><tbody><tr>`;

                let soma = 0;
                colunas.forEach(col => {
                    let valor = disc.notas[col] ?? '';
                    let valorExibir = valor;

                    if (valor.toUpperCase() === 'N') {
                        valorExibir = 'Não apresentou';
                        soma += 0;
                    } else if (valor.toUpperCase() === 'F') {
                        valorExibir = 'Aluno ausente';
                        soma += 0;
                    } else if (!isNaN(valor)) {
                        soma += parseFloat(valor.toString().replace(',', '.'));
                    }

                    html += `<td>${valorExibir}</td>`;
                });

                const media = colunas.length > 0 ? (soma / colunas.length) : 0;
                html += `<td><strong>${(media * 0.8).toFixed(2).replace('.', ',')}</strong></td>`;

                html += `</tr></tbody></table><br>`;
            });

            html += `<hr>`;
            $('#resultado').append(html);
        });
    }

    // Clique nos cabeçalhos para abrir modal
    $(document).on('click', 'th[data-coluna]', function(){
        const coluna = $(this).data('coluna');
        const titulo = coluna.toUpperCase().replace('t', 'NT');
        const turma = $(this).data('turma');
        const disciplina = $(this).data('disciplina');
        const idturma = $(this).data('idturma');

        $('#modalNTLabel').html(`Informações da Tarefa <strong>${titulo}</strong><br><small>Turma: <strong>${turma}</strong> | Disciplina: <strong>${disciplina}</strong></small>`);

        $('#conteudoModalNT').html('Carregando informações da tarefa...');

        $.ajax({
            url: 'info_tarefas.php',
            method: 'GET',
            data: { tarefa: titulo, turma: turma, disciplina: disciplina, idturma: idturma },
            success: function(data){
                $('#conteudoModalNT').html(data);
            },
            error: function(){
                $('#conteudoModalNT').html('Erro ao carregar informações.');
            }
        });

        $('#modalNT').modal('show');
    });

});
</script>

</body>
</html>
