<?php
header('Content-Type: application/json');

$pdo = new PDO("mysql:host=localhost;dbname=kaltekgo_avila;charset=utf8", "kaltekgo_admin", "kaltek@2024");
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

$nome = isset($_GET['nome']) ? trim($_GET['nome']) : '';
$resultados = [];

if ($nome != '') {
    $sql = "
        SELECT 
            n.id_turma, 
            n.id_disciplina,
            t.identificador_serie AS nome_turma,
            d.nomeDisciplina AS nome_disciplina,
            n.nome, 
            n.matricula,
            n.t1, n.t2, n.t3, n.t4, n.t5, n.t6, n.t7, n.t8, n.t9, n.t10,
            n.t11, n.t12, n.t13, n.t14, n.t15, n.t16, n.t17, n.t18, n.t19, n.t20,
            n.t21, n.t22, n.t23, n.t24, n.t25, n.t26, n.t27, n.t28, n.t29, n.t30
        FROM nota_tarefas_entregues n
        LEFT JOIN serie_turma_turno t ON n.id_turma = t.id_serie_turma
        LEFT JOIN disciplinas d ON n.id_disciplina = d.id_disciplina
        WHERE n.nome LIKE ?
    ";

    $stmt = $pdo->prepare($sql);
    $param = "%$nome%";
    $stmt->execute([$param]);
    $resultado = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($resultado as $row) {
        $dados = [
            'id_turma'      => $row['nome_turma'] ?? $row['id_turma'],
            'idturma'     => $row['id_turma'],
            'id_disciplina' => $row['nome_disciplina'] ?? $row['id_disciplina'],
            'nome'          => $row['nome'],
            'matricula'     => $row['matricula'],
            'notas'         => []
        ];

        for ($i = 1; $i <= 30; $i++) {
            $coluna = "t$i";
            if (isset($row[$coluna])) {
                $dados['notas'][$coluna] = $row[$coluna];
            }
        }

        $resultados[] = $dados;
    }
}

$alunos = [];
foreach ($resultados as $r) {
    $key = $r['matricula'] . '-' . $r['nome'];

    if (!isset($alunos[$key])) {
        $alunos[$key] = [
            'nome' => $r['nome'],
            'matricula' => $r['matricula'],
            'turma' => $r['id_turma'],
            'disciplinas' => []
        ];
    }

    $alunos[$key]['disciplinas'][] = [
        'disciplina' => $r['id_disciplina'],
        'notas' => $r['notas']
    ];
}

echo json_encode(array_values($alunos), JSON_UNESCAPED_UNICODE);
?>
