<?php
$host = 'localhost';
$db = 'kaltekgo_avila';
$user = 'kaltekgo_admin';
$pass = 'kaltek@2024';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("<div class='alert alert-danger'>Erro na conexão: " . $e->getMessage() . "</div>");
}

if (isset($_GET['tarefa'], $_GET['turma'], $_GET['disciplina'])) {
    $tarefa = $_GET['tarefa'];
    $turma = $_GET['turma'];
    $disciplina = $_GET['disciplina'];
    $idturma = $_GET['idturma'];

    try {
        $sql = "SELECT * 
                FROM tarefas_cadastradas 
                WHERE identificador_turma = :turma 
                  AND nomeDisciplina = :disciplina 
                  AND identificadorTarefa = :tarefa";

        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            ':turma' => $turma,
            ':disciplina' => $disciplina,
            ':tarefa' => 'N' . strtoupper($tarefa) // Formata N + tarefa (ex.: NT1)
        ]);

        if ($stmt->rowCount() > 0) {
            $tarefaInfo = $stmt->fetch(PDO::FETCH_ASSOC);

            echo "<p><strong>Tarefa:</strong> {$tarefaInfo['tituloTarefa']}</p>";
            echo "<p><strong>Professor(a):</strong> {$tarefaInfo['nomeProfessor']}</p>";
            echo "<p><strong>Disciplina:</strong> {$tarefaInfo['nomeDisciplina']}</p>";
            echo "<p><strong>Trimestre:</strong> {$tarefaInfo['nomeTrimestre']}</p>";
            
            $data = !empty($tarefaInfo['data_tarefa']) 
                    ? date('d/m/Y', strtotime($tarefaInfo['data_tarefa'])) 
                    : 'Sem data';

            echo "<p><strong>Data da Tarefa:</strong> {$data}</p>";
            echo "<p><strong>Tipo de Tarefa:</strong> {$tarefaInfo['tipoTarefa']}</p>";
        } else {
            echo "<div class='alert alert-warning'>Nenhuma informação encontrada para a tarefa selecionada.</div>";
        }

    } catch (PDOException $e) {
        echo "<div class='alert alert-danger'>Erro na consulta: " . $e->getMessage() . "</div>";
    }

} else {
    echo "<div class='alert alert-danger'>Parâmetros inválidos. Verifique tarefa, turma e disciplina.</div>";
}
?>
<?php
 
 echo $idturma;
?>
