<?php
file_put_contents('debug_post.txt', print_r($_POST, true));
// Define tempo de vida da sessão (12 horas)
ini_set('session.gc_maxlifetime', 14400);
session_set_cookie_params(14400);

// Inicia a sessão
session_start();

// Redireciona se a sessão não estiver definida
if (!isset($_SESSION['idProfessor']) || !isset($_SESSION['nomeProfessor'])) {
    header("Location: https://avilagoiania.kaltekgoiania.com.br/simulados/tarefas/login.php");
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>Tarefas Cadastradas</title>
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
  <style>
    body {
      font-family: Arial, sans-serif;
      background-color: #ffffff;
      margin: 20px;
      color: #000000;
    }

    .topo-logo {
      display: flex;
      align-items: flex-start;
      gap: 20px;
      margin-bottom: 20px;
    }

    .topo-logo img {
      max-width: 200px;
      height: auto;
      position: absolute;
      margin-left: 1100px;
    }

    .info-topo {
      flex: 1;
    }

    .container-fluid {
      width: 100%;
    }

    h4, h5 {
      margin: 0 0 10px;
    }

    .btn-cadastrar, .filtro-btns {
      margin-left: 15px;
      margin-bottom: 10px;
    }

    .table-responsive-custom {
      overflow-x: auto;
      margin: 0 15px 20px 15px;
      display: block;
    }

    table {
      white-space: nowrap;
      width: 100%;
      border-collapse: collapse;
      background-color: #ffffff;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
      text-transform: uppercase;
      min-width: 700px;
    }

    th, td {
      padding: 12px 15px;
      text-align: left;
      font-size: 12px;
      border: 1px solid #000;
      vertical-align: middle !important;
    }

    th {
      background-color: #000;
      color: #fff;
    }

    tr:nth-child(even) {
      background-color: #f4f4f4;
    }

    tr:hover {
      background-color: #e0e0e0;
    }

    @media (max-width: 768px) {
      .btn-cadastrar, .filtro-btns .btn {
        width: 100% !important;
        margin: 10px auto;
        font-size: 16px;
        height: 45px;
        padding: 10px 12px;
      }

      .form-group label,
      .form-control {
        font-size: 14px;
      }

      .form-control,
      input[type="text"],
      select {
        height: 40px;
      }

      .table-responsive-custom {
        overflow-x: auto;
        display: block;
      }

      table {
        width: auto;
      }

      .table th, .table td {
        min-width: 125px;
        font-size: 14px;
        padding: 8px 10px;
      }

      h4 {
        text-align: center;
      }
    }
  </style>
</head>
<body>
<div class="container-fluid">
  <h2 class="text-center">Lista de Tarefas</h2>
  <p>
    <button class="btn btn-success" onclick="window.open('https://avilagoiania.kaltekgoiania.com.br/simulados/tarefas/index.php', '_blank')">Tela Registro Tarefas</button>
    <button class="btn btn-success" onclick="window.location.href='https://avilagoiania.kaltekgoiania.com.br/simulados/tarefas/logout.php'">Clique aqui para sair</button>
    <button class="btn btn-warning filtro" data-filtro="TAREFA CASA">Tarefa Casa</button>
    <button class="btn btn-success filtro" data-filtro="TAREFA SALA">Tarefa Sala</button>
    <button class="btn btn-info filtro" data-filtro="TODOS">Todos</button>
  </p>

  <table class="table table-bordered table-striped" id="tabelaTarefas">
    <thead>
      <tr>
        <th>ID</th>
        <th>Título</th>
        <th>Disciplina</th>
        <th>Turma</th>
        <th>Trimestre</th>
        <th>Professor</th>
        <th>Data</th>
        <th>Tipo Tarefa</th>
      </tr>
    </thead>
    <tbody></tbody>
  </table>
  <div class="text-center" id="paginador" style="margin: 20px 0;"></div>
</div>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
<script>
function quebrarTexto(texto, limite) {
  if (texto.length <= limite) return texto;
  let partes = texto.match(new RegExp('.{1,' + limite + '}', 'g'));
  return partes.join('<br>');
}

var dadosTarefas = [];
var registrosPorPagina = 8;
var paginaAtual = 1;
var filtroAtual = "TODOS";

function formatarData(dataISO) {
  var partes = dataISO.split("-");
  return partes[2] + '/' + partes[1] + '/' + partes[0];
}

function aplicarFiltro() {
  return dadosTarefas.filter(function(tarefa) {
    const tipo = (tarefa.tipoTarefa || "").trim().toUpperCase();
    return filtroAtual === "TODOS" || tipo === filtroAtual;
  });
}

function exibirTabela(pagina) {
  var tbody = $('#tabelaTarefas tbody');
  tbody.empty();

  var tarefasFiltradas = aplicarFiltro();

  var inicio = (pagina - 1) * registrosPorPagina;
  var fim = inicio + registrosPorPagina;
  var tarefasPagina = tarefasFiltradas.slice(inicio, fim);

  tarefasPagina.forEach(function(tarefa) {
    var dataFormatada = formatarData(tarefa.data_tarefa);
    var row = '<tr>' +
      '<td>' + tarefa.identificadorTarefa + '</td>' +
      '<td>' + quebrarTexto(tarefa.tituloTarefa, 40) + '</td>' +
      '<td>' + tarefa.nomeDisciplina + '</td>' +
      '<td><a href="alunosTarefasNaoFeitas.php?id_turma=' + tarefa.id_turma + '&id_disciplina=' + tarefa.idDisciplina + '&identificadorTarefa=' + tarefa.identificadorTarefa + '&titulo=' + tarefa.tituloTarefa + '&disciplina=' + tarefa.nomeDisciplina + '&turma=' + tarefa.identificador_turma + '&professor=' + tarefa.nomeProfessor + '&tipo=' + tarefa.tipoTarefa + '&data=' + dataFormatada + '&trimestre=' + tarefa.nomeTrimestre +'">' + tarefa.identificador_turma + '</a></td>' +
      '<td>' + tarefa.nomeTrimestre + '</td>' +
      '<td>' + tarefa.nomeProfessor + '</td>' +
      '<td>' + dataFormatada + '</td>' +
      '<td>' + tarefa.tipoTarefa + '</td>' +
      '</tr>';
    tbody.append(row);
  });
}


function criarPaginacao() {
  var tarefasFiltradas = aplicarFiltro();
  var totalPaginas = Math.ceil(tarefasFiltradas.length / registrosPorPagina);
  var paginador = $('#paginador');
  paginador.empty();

  for (var i = 1; i <= totalPaginas; i++) {
    var btn = $('<button class="btn btn-default btn-sm pag-btn">' + i + '</button>');
    if (i === paginaAtual) {
      btn.addClass('btn-primary');
    }
    btn.on('click', function () {
      paginaAtual = parseInt($(this).text());
      exibirTabela(paginaAtual);
      criarPaginacao();
    });
    paginador.append(btn);
  }
}

$(document).ready(function(){
  // Evento de clique nos botões de filtro
  $('.filtro').on('click', function() {
    filtroAtual = $(this).data('filtro').toUpperCase();
    paginaAtual = 1;
    exibirTabela(paginaAtual);
    criarPaginacao();
  });

  // AJAX para carregar dados
  $.ajax({
    url: 'buscar_tarefas.php',
    method: 'GET',
    dataType: 'json',
    success: function(data) {
      dadosTarefas = data;
      exibirTabela(paginaAtual);
      criarPaginacao();
    },
    error: function(xhr, status, error) {
      alert("Erro ao buscar tarefas: " + error);
    }
  });
});
</script>
</body>
</html>
