<?php
// Configuração do banco de dados
$host = 'localhost';
$dbname = 'kaltekgo_avila';
$username = 'kaltekgo_admin';
$password = 'kaltek@2024';

// Conexão com o banco de dados
try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Erro ao conectar ao banco de dados: " . $e->getMessage());
}

// Consulta para obter as turmas
$sql = "SELECT DISTINCT turma
FROM alunos_fundamental1
WHERE id_turma BETWEEN 19 AND 33
ORDER BY turma ASC;"; // Apenas turmas distintas
$stmt = $pdo->query($sql);
$turmas = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Estatísticas de Desempenho</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            background-color: #fff;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            background-color: #fff;
            min-width: 700px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            text-transform: uppercase;
        }
        th, td {
            padding: 10px;
            font-size: 12px;
            border: 1px solid #000;
            text-align: left;
        }
        th {
            background-color: #000;
            color: #fff;
        }
        tr:nth-child(even) {
            background-color: #f4f4f4;
        }
        tr:hover {
            background-color: #e0e0e0;
        }
        .margin {
            margin-bottom: 8px;
        }
         .header-bar {
            width: 100%;
            padding: 10px;
            background: #f5f5f5;
            border-bottom: 1px solid #ddd;
            position: fixed;
            top: 0;
            right: 0;
            left: 0;
            z-index: 1000;
        }
        .header-bar .header-content {
            display: flex;
            justify-content: flex-end;
            align-items: center;
        }
        .header-bar .welcome {
            font-size: 16px;
            font-weight: bold;
            margin-right: 10px;
        }
        .header-bar .btn {
            margin-left: 5px;
        }
        
    </style>
</head>
<body>
<div class="container mt-5">
    <h2 class="mb-4">Estatísticas de Desempenho <strong>- FUNDAMENTAL I</strong></h2>

    <!-- Select para escolher a turma -->
    <select id="select-turma" class="form-control mb-4">
        <option value="">Selecione a Turma</option>
        <?php foreach ($turmas as $turma): ?>
            <option value="<?= htmlspecialchars($turma['turma']) ?>"><?= htmlspecialchars($turma['turma']) ?></option>
        <?php endforeach; ?>
    </select>
    <br>
    <!-- Estatísticas e Tabela -->
    <div id="estatisticas" class="mb-4">
        <div class="alert alert-info" id="nota-max-min"></div>
        <div class="alert alert-success" id="quantidade-notas"></div>
    </div>

    <div id="tabela-alunos"></div> <!-- Div onde a tabela será carregada -->

    <div style="padding-bottom: 20px;">
        <!--button class="btn btn-success btn-sm" onclick="history.back()">VOLTAR</button-->
    </div>
</div>

<script>
    $(document).ready(function () {
        $('#select-turma').change(function () {
            const turmaSelecionada = $(this).val();
            
            if (turmaSelecionada) {
                $.ajax({
                    url: 'load_data.php',
                    type: 'GET',
                    data: { turma: turmaSelecionada },
                    success: function (response) {
                        const data = JSON.parse(response);
                        
                        if (data.success) {
                            // Exibir estatísticas
                            $('#nota-max-min').html(
                                `Nota mais alta: <strong>${parseFloat(data.nota_maxima).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 })}</strong> <strong>(${data.alunos_max})</strong><br>
                                 Nota mais baixa: <strong>${parseFloat(data.nota_minima).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 })}</strong> <strong>(${data.alunos_min})</strong>`
                            );
                            $('#quantidade-notas').html(
    `Notas abaixo de 5: <strong>${data.abaixo5}</strong><br>
     Notas iguais a 5: <strong>${data.igual5}</strong><br>
     Notas acima de 5: <strong>${data.acima5}</strong><br>
     Total de alunos: <strong>${data.total_alunos}</strong><br>
     Total de alunos válidos: <strong>${data.total_validas}</strong><br>
     Média da turma: <strong>${parseFloat(data.media_turma).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 })}</strong>`
);

                            
                            // Exibir a tabela de alunos
                            let tableHtml = '<table class="table table-bordered table-striped">';
                            tableHtml += '<thead class="thead-dark" style="font-size:11px;"><tr><th>Matrícula</th><th>Nome</th><th>Turma</th><th>Nota (Obtida)</th><th>Nota (Considerada)</th></tr></thead><tbody>';
                            
                            data.alunos.forEach(function(aluno) {
    const nota = parseFloat(aluno.nota_saeca);
    const notaFormatada = nota.toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
    const notaClass = nota < 5 ? 'style="color: red; font-weight: bold;"' : '';
    
    tableHtml += `<tr>
                    <td>${aluno.matricula}</td>
                    <td>${aluno.nome}</td>
                    <td>${aluno.turma}</td>
                    <td ${notaClass}>${notaFormatada}</td>
                    <td ${notaClass}>${notaFormatada}</td>
                  </tr>`;
});

                            
                            tableHtml += '</tbody></table>';
                            
                            $('#tabela-alunos').html(tableHtml);
                        } else {
                            $('#nota-max-min').html('Nenhum dado encontrado.');
                            $('#quantidade-notas').html('');
                            $('#tabela-alunos').html('');
                        }
                    }
                });
            } else {
                $('#nota-max-min').html('');
                $('#quantidade-notas').html('');
                $('#tabela-alunos').html('');
            }
        });
    });
</script>

<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
