<?php
// Configuração do banco de dados
$host = 'localhost';
$dbname = 'kaltekgo_avila';
$username = 'kaltekgo_admin';
$password = 'kaltek@2024';

// Conexão com o banco de dados
try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Erro ao conectar ao banco de dados: " . $e->getMessage());
}

// Verifica se a turma foi passada na solicitação
if (isset($_GET['turma'])) {
    $turma = $_GET['turma'];

    // Consulta para obter os alunos da turma selecionada
    $sql = "SELECT matricula, nome, turma, desempenho, nota_saeca FROM alunos_fundamental1 WHERE turma = :turma ORDER BY nome";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['turma' => $turma]);
    $alunos = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $total_alunos = count($alunos);

    // Filtrar apenas notas válidas (> 0 e numéricas)
    $notas_validas = array_filter($alunos, function($aluno) {
        return isset($aluno['nota_saeca']) && is_numeric($aluno['nota_saeca']) && $aluno['nota_saeca'] > 0;
    });

    // Extrair apenas os valores das notas válidas
    $valores_validos = array_column($notas_validas, 'nota_saeca');

    // Calcular média com base apenas nas notas válidas
    $total_validas = count($valores_validos);
    $soma_validas = array_sum($valores_validos);
    $media_turma = $total_validas > 0 ? $soma_validas / $total_validas : 0;

    // Estatísticas de desempenho
    $desempenhos = array_column($alunos, 'nota_saeca');

    // Filtrar desempenhos para remover valores iguais a 0
    $desempenhos_validos = array_filter($desempenhos, fn($nota) => $nota > 0);

    if (!empty($desempenhos_validos)) {
        // Encontrar a maior e a menor nota
        $nota_maxima = max($desempenhos_validos);
        $nota_minima = min($desempenhos_validos);

        // Filtrar nomes com maior e menor nota
        $nomes_max = array_keys(array_filter($desempenhos, fn($nota) => $nota == $nota_maxima));
        $nomes_min = array_keys(array_filter($desempenhos, fn($nota) => $nota == $nota_minima));

        $alunos_max = implode(', ', array_map(fn($key) => $alunos[$key]['nome'], $nomes_max));
        $alunos_min = implode(', ', array_map(fn($key) => $alunos[$key]['nome'], $nomes_min));
    } else {
        // Caso não haja notas válidas
        $nota_maxima = null;
        $nota_minima = null;
        $alunos_max = 'Nenhum';
        $alunos_min = 'Nenhum';
    }

    // Contar desempenhos
    $abaixo5 = count(array_filter($desempenhos, fn($nota) => $nota < 5 && $nota > 0));
    $igual5 = count(array_filter($desempenhos, fn($nota) => $nota == 5));
    $acima5 = count(array_filter($desempenhos, fn($nota) => $nota > 5));

    // Retornar os dados como JSON
    echo json_encode([
        'success' => true,
        'nota_maxima' => $nota_maxima,
        'alunos_max' => $alunos_max,
        'nota_minima' => $nota_minima,
        'alunos_min' => $alunos_min,
        'abaixo5' => $abaixo5,
        'igual5' => $igual5,
        'acima5' => $acima5,
        'total_alunos' => $total_alunos,
        'total_validas' => $total_validas,
        'media_turma' => $media_turma,
        'alunos' => $alunos
    ]);

} else {
    echo json_encode(['success' => false, 'message' => 'Turma não especificada.']);
}
?>
