<?php
// Configuração do banco de dados
$host = 'localhost';
$dbname = 'kaltekgo_avila';
$username = 'kaltekgo_admin';
$password = 'kaltek@2024';

// Conexão com o banco de dados
try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Erro ao conectar ao banco de dados: " . $e->getMessage());
}

// Verifica se a turma foi passada na solicitação
if (isset($_GET['turma'])) {
    $turma = $_GET['turma'];

    // Consulta para obter os dados da turma selecionada
    $sql = "SELECT * FROM alunos_fundamental1 WHERE turma = :turma";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['turma' => $turma]);
    $alunos = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Extrair os desempenhos e nomes
    $desempenhos = array_column($alunos, 'nota_saeca');
    $nomes = array_column($alunos, 'nome');

    // Encontrar a maior e a menor nota
    $nota_maxima = max($desempenhos);
    $nota_minima = min($desempenhos);

    // Filtrar nomes com maior e menor nota
    $nomes_max = array_keys(array_filter($desempenhos, fn($nota) => $nota == $nota_maxima));
    $nomes_min = array_keys(array_filter($desempenhos, fn($nota) => $nota == $nota_minima));

    $alunos_max = implode(', ', array_map(fn($key) => $nomes[$key], $nomes_max));
    $alunos_min = implode(', ', array_map(fn($key) => $nomes[$key], $nomes_min));

    // Contar desempenhos
    $abaixo5 = count(array_filter($desempenhos, fn($nota) => $nota < 5));
    $igual5 = count(array_filter($desempenhos, fn($nota) => $nota == 5));
    $acima5 = count(array_filter($desempenhos, fn($nota) => $nota > 5));

    // Retornar os dados como JSON
    echo json_encode([
        'success' => true,
        'nota_maxima' => $nota_maxima,
        'nota_minima' => $nota_minima,
        'alunos_max' => $alunos_max,
        'alunos_min' => $alunos_min,
        'abaixo5' => $abaixo5,
        'igual5' => $igual5,
        'acima5' => $acima5,
    ]);
} else {
    echo json_encode(['success' => false]);
}
?>
