<?php
header('Content-Type: application/json');

// Inicializa um array de resultados
$resultado = [];

try {
    // Percorre de t1 até t30
    for ($i = 1; $i <= 30; $i++) {
        $campo = "t{$i}";
        
        // Verifica se o campo existe no $_POST e se é um array
        if (isset($_POST[$campo]) && is_array($_POST[$campo])) {
            $resultado[$campo] = [
                'presente' => true,
                'quantidade' => count($_POST[$campo]),
                'exemplo_valor' => $_POST[$campo][0] ?? null
            ];
        } else {
            $resultado[$campo] = [
                'presente' => false,
                'mensagem' => "Campo {$campo} ausente ou não é um array"
            ];
        }
    }

    echo json_encode([
        'sucesso' => true,
        'verificacao' => $resultado
    ]);

} catch (Exception $e) {
    echo json_encode([
        'sucesso' => false,
        'mensagem' => 'Erro: ' . $e->getMessage()
    ]);
}
