<?php
// Configuração do banco de dados
$host = 'localhost';
$dbname = 'kaltekgo_avila';
$username = 'kaltekgo_admin';
$password = 'kaltek@2024';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Erro ao conectar ao banco de dados: " . $e->getMessage());
}

// Caso seja uma requisição AJAX
if (isset($_GET['turma_id'])) {
    $turma_id = $_GET['turma_id'];

    // Consulta os dados: Se turma_id for 0, retorna todos os dados
    if ($turma_id == 0) {
        $sql = "SELECT * FROM alunos_fundamental1";
        $stmt = $pdo->query($sql);
    } else {
        $sql = "SELECT * FROM alunos_fundamental1 WHERE id_turma_agregada = :turma_id";
        $stmt = $pdo->prepare($sql);
        $stmt->execute(['turma_id' => $turma_id]);
    }

    $alunos = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Processa os dados e retorna como JSON
    if (count($alunos) > 0) {
        $desempenhos = array_column($alunos, 'nota_saeca');
        $nomes = array_column($alunos, 'nome');

        // Filtrar desempenhos para remover valores iguais a 0
        $desempenhos_validos = array_filter($desempenhos, fn($nota) => $nota > 0);

        if (!empty($desempenhos_validos)) {
            // Encontrar a maior e a menor nota
            $nota_maxima = max($desempenhos_validos);
            $nota_minima = min($desempenhos_validos);

            $nomes_max = array_keys(array_filter($desempenhos, fn($nota) => $nota == $nota_maxima));
            $nomes_min = array_keys(array_filter($desempenhos, fn($nota) => $nota == $nota_minima));

            $alunos_max = implode(', ', array_map(fn($key) => $nomes[$key], $nomes_max));
            $alunos_min = implode(', ', array_map(fn($key) => $nomes[$key], $nomes_min));

            $abaixo5 = count(array_filter($desempenhos, fn($nota) => $nota < 5 && $nota > 0));
            $igual5 = count(array_filter($desempenhos, fn($nota) => $nota == 5));
            $acima5 = count(array_filter($desempenhos, fn($nota) => $nota > 5));
        } else {
            $nota_maxima = null;
            $nota_minima = null;
            $alunos_max = 'Nenhum';
            $alunos_min = 'Nenhum';
            $abaixo5 = $igual5 = $acima5 = 0;
        }

        echo json_encode([
            'nota_maxima' => $nota_maxima,
            'nota_minima' => $nota_minima,
            'alunos_max' => $alunos_max,
            'alunos_min' => $alunos_min,
            'abaixo5' => $abaixo5,
            'igual5' => $igual5,
            'acima5' => $acima5
        ]);
    } else {
        echo json_encode([
            'nota_maxima' => null,
            'nota_minima' => null,
            'alunos_max' => 'Nenhum',
            'alunos_min' => 'Nenhum',
            'abaixo5' => 0,
            'igual5' => 0,
            'acima5' => 0
        ]);
    }
    exit;
}

// Consulta as turmas para o select
$turmas_sql = "SELECT DISTINCT id_turma_agregada, turma_nome FROM turma_agregada ORDER BY id_turma_agregada ASC";
$turmas_stmt = $pdo->query($turmas_sql);
$turmas = $turmas_stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Estatísticas de Desempenho</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body>
<div class="container mt-5">
    <h3 class="mb-4">Estatísticas de Desempenho</h3>
    <h4 class="mb-4">Por Turmas Agregadas</h4>

    <!-- Select para filtrar turmas -->
    <div class="form-group">
        <label for="turmaSelect">Selecione uma turma:</label>
        <select id="turmaSelect" class="form-control">
            <option></option>
            <?php foreach ($turmas as $turma): ?>
                <option value="<?= htmlspecialchars($turma['id_turma_agregada']) ?>">
                    <?= htmlspecialchars($turma['turma_nome']) ?>
                </option>
            <?php endforeach; ?>
        </select>
    </div>

    <!-- Estatísticas -->
    <div id="estatisticas" class="mb-4">
        <div class="alert alert-info" id="nota-max-min"></div>
        <div class="alert alert-success" id="quantidade-notas"></div>
    </div>

    <div style="padding-bottom: 20px;">
        <button class="btn btn-success" onclick="history.back()">VOLTAR</button>
    </div>
</div>

<script>
    $(document).ready(function () {
        $('#turmaSelect').on('change', function () {
            const turmaId = $(this).val();
            
            // Faz requisição AJAX para buscar os dados
            $.ajax({
                url: '<?= $_SERVER['PHP_SELF'] ?>',
                method: 'GET',
                data: { turma_id: turmaId },
                dataType: 'json',
                success: function (data) {
                    // Atualiza as estatísticas
                    $('#nota-max-min').html(
                        `<p>Nota mais alta: <strong>${data.nota_maxima || 'N/A'}</strong> (${data.alunos_max})</p>
                         <p>Nota mais baixa: <strong>${data.nota_minima || 'N/A'}</strong> (${data.alunos_min})</p>`
                    );
                    $('#quantidade-notas').html(
                        `<p>Notas abaixo de 5: <strong>${data.abaixo5}</strong></p>
                         <p>Notas iguais a 5: <strong>${data.igual5}</strong></p>
                         <p>Notas acima de 5: <strong>${data.acima5}</strong></p>`
                    );
                }
            });
        });
    });
</script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
