<?php
// Configuração do banco de dados
$host = 'localhost';
$dbname = 'kaltekgo_avila';
$username = 'kaltekgo_admin';
$password = 'kaltek@2024';

// Conexão com o banco de dados
try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Erro ao conectar ao banco de dados: " . $e->getMessage());
}

// Consulta para obter os dados
$sql = "SELECT DISTINCT turma FROM alunos_fundamental1"; // Apenas turmas distintas
$stmt = $pdo->query($sql);
$turmas = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Estatísticas de Desempenho</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body>
<div class="container mt-5">
    <h2 class="mb-4">Estatísticas de Desempenho</h2>

    <!-- Select para escolher a turma -->
    <select id="select-turma" class="form-control mb-4">
        <option value="">Selecione a Turma</option>
        <?php foreach ($turmas as $turma): ?>
            <option value="<?= htmlspecialchars($turma['turma']) ?>"><?= htmlspecialchars($turma['turma']) ?></option>
        <?php endforeach; ?>
    </select>

    <!-- Estatísticas -->
    <div id="estatisticas" class="mb-4">
        <div class="alert alert-info" id="nota-max-min"></div>
        <div class="alert alert-success" id="quantidade-notas"></div>
    </div>

    <div style="padding-bottom: 20px;">
        <button class="btn btn-success" onclick="history.back()">VOLTAR</button>
    </div>
</div>

<script>
    $(document).ready(function () {
        $('#select-turma').change(function () {
            const turmaSelecionada = $(this).val();
            if (turmaSelecionada) {
                $.ajax({
                    url: 'load_students.php',
                    type: 'GET',
                    data: { turma: turmaSelecionada },
                    success: function (response) {
                        const data = JSON.parse(response);
                        if (data.success) {
                            // Atualiza as estatísticas
                            $('#nota-max-min').html(
                                `Nota mais alta: <strong>${data.nota_maxima}</strong> (${data.alunos_max})<br>
                                 Nota mais baixa: <strong>${data.nota_minima}</strong> (${data.alunos_min})`
                            );
                            $('#quantidade-notas').html(
                                `Notas abaixo de 5: <strong>${data.abaixo5}</strong><br>
                                 Notas iguais a 5: <strong>${data.igual5}</strong><br>
                                 Notas acima de 5: <strong>${data.acima5}</strong>`
                            );
                        } else {
                            $('#nota-max-min').html('Nenhum dado encontrado.');
                            $('#quantidade-notas').html('');
                        }
                    }
                });
            } else {
                $('#nota-max-min').html('');
                $('#quantidade-notas').html('');
            }
        });
    });
</script>

<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
