<?php
require 'vendor/autoload.php'; // Inclua o autoload do Composer

use Dompdf\Dompdf;
use Dompdf\Options;

// Configuração do banco de dados
$host = 'localhost';
$dbname = 'kaltekgo_avila';
$username = 'kaltekgo_admin';
$password = 'kaltek@2024';

// Conexão com o banco de dados
try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Erro ao conectar ao banco de dados: " . $e->getMessage());
}

// Obter turma selecionada
$turma = $_GET['turma'] ?? '';
if (!$turma) {
    die('Turma não especificada.');
}

// Obter dados da turma
$sql = "SELECT matricula, nome, turma, desempenho, ROUND(desempenho * 5, 2) AS nota FROM simulado_geral WHERE turma = ?";
$stmt = $pdo->prepare($sql);
$stmt->execute([$turma]);
$alunos = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Geração do HTML para o PDF
$html = '<h2 style="text-align: center;">Estatísticas de Desempenho</h2>';
$html .= "<p>Turma: <strong>{$turma}</strong></p>";
$html .= '<table border="1" cellspacing="0" cellpadding="5" style="width: 100%; font-size: 12px; border-collapse: collapse;">
            <thead>
                <tr>
                    <th>Matrícula</th>
                    <th>Nome</th>
                    <th>Turma</th>
                    <th>Nota (0,0 a 2,00)</th>
                    <th>Nota (0,0 a 10,0)</th>
                </tr>
            </thead>
            <tbody>';

foreach ($alunos as $aluno) {
    $html .= "<tr>
                <td>{$aluno['matricula']}</td>
                <td>{$aluno['nome']}</td>
                <td>{$aluno['turma']}</td>
                <td>{$aluno['desempenho']}</td>
                <td>{$aluno['nota']}</td>
              </tr>";
}

$html .= '</tbody></table>';

// Configuração do DOMPDF
$options = new Options();
$options->set('isRemoteEnabled', true);

$dompdf = new Dompdf($options);
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');

// Renderização do PDF
$dompdf->render();

// Envio do PDF para o navegador
$dompdf->stream("estatisticas_turma_{$turma}.pdf", ["Attachment" => false]);
exit;
?>
