<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Relatório de Desempenho</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <!-- Título da página -->
        <div class="text-center mb-4">
            <h1 class="display-5">Relatório de Desempenho</h1>
            <p class="text-muted">Selecione uma turma para gerar o relatório</p>
        </div>

        <!-- Formulário -->
        <form action="relatorios.php" method="GET" target="_blank">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="selectTurma" class="form-label">Turma:</label>
                        <select id="selectTurma" name="id_turma" class="form-select" required>
                            <option value="" disabled selected>Selecione uma turma</option>
                            <?php
                            // Configuração do banco de dados
                            $host = 'localhost';
                            $dbname = 'kaltekgo_avila';
                            $username = 'kaltekgo_admin';
                            $password = 'kaltek@2024';

                            try {
                                $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
                                $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

                                // Buscar turmas disponíveis
                                $sql = "SELECT DISTINCT id_turma, turma FROM simulado_geral_ftd ORDER BY turma ASC";
                                $stmt = $pdo->query($sql);
                                $turmas = $stmt->fetchAll(PDO::FETCH_ASSOC);

                                foreach ($turmas as $turma) {
                                    echo '<option value="' . htmlspecialchars($turma['id_turma']) . '">' . htmlspecialchars($turma['turma']) . '</option>';
                                }
                            } catch (PDOException $e) {
                                echo '<option value="" disabled>Erro ao carregar turmas</option>';
                            }
                            ?>
                        </select>
                    </div>
                </div>
            </div>

            <!-- Botão Submit -->
            <div class="text-center">
                <button type="submit" class="btn btn-primary">Gerar Relatório</button>
            </div>
        </form>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
