<?php
// Configuração do banco de dados
$host = 'localhost';
$dbname = 'kaltekgo_avila';
$username = 'kaltekgo_admin';
$password = 'kaltek@2024';

// Conexão com o banco de dados
try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Erro ao conectar ao banco de dados: " . $e->getMessage());
}

// Verifica se a turma foi passada na solicitação
if (isset($_GET['turma'])) {
    $turma = $_GET['turma'];

    // Consulta para obter os alunos da turma selecionada
    $sql = "SELECT matricula, nome, turma, desempenho FROM simulado_geral_ftd WHERE turma = :turma ORDER BY nome";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['turma' => $turma]);
    $alunos = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Estatísticas de desempenho
    $desempenhos = array_column($alunos, 'desempenho');

    // Filtrar desempenhos para remover valores iguais a 0
    $desempenhos_validos = array_filter($desempenhos, fn($nota) => $nota > 0);

    if (!empty($desempenhos_validos)) {
        // Encontrar a maior e a menor nota
        $nota_maxima = max($desempenhos_validos);
        $nota_minima = min($desempenhos_validos);

        // Filtrar nomes com maior e menor nota
        $nomes_max = array_keys(array_filter($desempenhos, fn($nota) => $nota == $nota_maxima));
        $nomes_min = array_keys(array_filter($desempenhos, fn($nota) => $nota == $nota_minima));

        $alunos_max = implode(', ', array_map(fn($key) => $alunos[$key]['nome'], $nomes_max));
        $alunos_min = implode(', ', array_map(fn($key) => $alunos[$key]['nome'], $nomes_min));
    } else {
        // Caso não haja notas válidas
        $nota_maxima = null;
        $nota_minima = null;
        $alunos_max = 'Nenhum';
        $alunos_min = 'Nenhum';
    }

    // Contar desempenhos
    $abaixo5 = count(array_filter($desempenhos, fn($nota) => $nota < 5 && $nota > 0));
    $igual5 = count(array_filter($desempenhos, fn($nota) => $nota == 5));
    $acima5 = count(array_filter($desempenhos, fn($nota) => $nota > 5));

    // Retornar os dados como JSON
    echo json_encode([
        'success' => true,
        'alunos' => $alunos,
        'nota_maxima' => $nota_maxima,
        'nota_minima' => $nota_minima,
        'alunos_max' => $alunos_max,
        'alunos_min' => $alunos_min,
        'abaixo5' => $abaixo5,
        'igual5' => $igual5,
        'acima5' => $acima5
    ]);
} else {
    echo json_encode(['success' => false, 'message' => 'Turma não especificada.']);
}
?>
