<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>P3 Dinâmico</title>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #ffffff;
            margin: 20px;
            color: #000000;
        }
        h4, h5 { margin: 0 0 10px; }
        .btn-cadastrar { margin-left: 15px; margin-bottom: 10px; }
        .filtro-btns { margin-left: 15px; margin-bottom: 15px; display: flex; flex-wrap: wrap; }
        .filtro-btns .btn { margin-right: 10px; margin-bottom: 5px; }
        .table-responsive-custom {
            overflow-x: auto;
            margin: 0 15px 20px 15px;
        }
        table {
            white-space: nowrap;
            width: 100%;
            border-collapse: collapse;
            background-color: #ffffff;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            text-transform: uppercase;
            min-width: 700px;
        }
        th, td {
            padding: 12px 15px;
            text-align: left;
            font-size: 12px;
            border: 1px solid #000000;
            white-space: nowrap;
            vertical-align: middle !important;
        }
        th {
            background-color: #000000;
            color: #ffffff;
        }
        tr:nth-child(even) { background-color: #f4f4f4; }
        tr:hover { background-color: #e0e0e0; }
        @media (max-width: 768px) {
            .btn-cadastrar,
            .filtro-btns .btn {
                width: 92% !important;
                display: flex;
                justify-content: center;
                align-items: center;
                margin: 10px auto;
                font-size: 14px;
                height: 40px;
                padding: 8px 10px;
            }
            a.btn-cadastrar { display: block; text-align: center; margin-left: 13px !important; }
            .table th, .table td {
                min-width: 125px;
                white-space: nowrap;
                font-size: 14px;
                padding: 8px 10px;
            }
            h4 { text-align: center; }
        }
        .linha-equipamento { cursor: pointer; }
    </style>
</head>
<body>
<div class="container">
    <h4>CÁLCULO NOTA P3</h4>
    <h5>LEGENDAS</h5>
    <p>NT = NOTA TAREFAS / NS = NOTAS SALA DE AULA / MP = MÉDIA POINT / S = NOTA SIMULADO / P3 = NOTA QUE SERÁ LANÇADA</p>
    <div id="alerta" class="alert d-none"></div>

    <div class="row">
        <div class="col-md-6">
            <label for="selectTurma">Selecione a turma:</label>
            <select id="selectTurma" class="form-control">
                <option value="">Selecione...</option>
                <option value="1">6º ANO A</option>
                <option value="2">6º ANO B</option>
                <option value="3">7º ANO A</option>
                <option value="4">7º ANO B</option>
                <option value="5">8º ANO A</option>
                <option value="6">8º ANO B</option>
                <option value="7">9º ANO A</option>
                <option value="8">9º ANO B</option>
            </select>
        </div>
        <div class="col-md-6">
            <label for="selectTurma2">Selecione uma disciplina:</label>
            <select id="selectTurma2" class="form-control">
                <option value="">Selecione...</option>
                <option value="7">LÍNGUA PORTUGUESA</option>
                <option value="8">MATEMÁTICA</option>
                <option value="9">LÍNGUA ESTRANGEIRA MODERNA</option>
            </select>
        </div>
    </div>

    <br>
    <form id="formP3">
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Matrícula</th>
                    <th>Aluno</th>
                    <th>NT</th>
                    <th>NS</th>
                    <th>MP</th>
                    <th>S</th>
                    <th>P3</th>
                </tr>
            </thead>
            <tbody></tbody>
        </table>
        <!--button type="submit" class="btn btn-success">Calcular</button-->
    </form>
</div>

<script>
// Carrega valores salvos
window.addEventListener('DOMContentLoaded', () => {
    const turmaSalva = localStorage.getItem('turmaSelecionada');
    const disciplinaSalva = localStorage.getItem('disciplinaSelecionada');

    if (turmaSalva) document.getElementById('selectTurma').value = turmaSalva;
    if (disciplinaSalva) document.getElementById('selectTurma2').value = disciplinaSalva;

    carregarAlunosSeSelecionado(); // tenta carregar se ambos existirem
});

// Função que só carrega alunos se turma e disciplina estiverem selecionadas
function carregarAlunosSeSelecionado() {
    const turmaId = document.getElementById('selectTurma').value;
    const disciplinaId = document.getElementById('selectTurma2').value;
    const tbody = document.querySelector('table tbody');
    const alerta = document.getElementById('alerta');

    if (!turmaId || !disciplinaId) {
        tbody.innerHTML = '';
        return;
    }

    fetch(`buscar_alunos.php?id_turma=${turmaId}&id_disciplina=${disciplinaId}`)
        .then(response => response.text())
        .then(data => {
            tbody.innerHTML = data;
        })
        .catch(() => {
            alerta.classList.remove('d-none', 'alert-success');
            alerta.classList.add('alert-danger');
            alerta.textContent = 'Erro ao carregar alunos da turma.';
        });
}

// Eventos de seleção
document.getElementById('selectTurma').addEventListener('change', function () {
    localStorage.setItem('turmaSelecionada', this.value);
    carregarAlunosSeSelecionado();
});

document.getElementById('selectTurma2').addEventListener('change', function () {
    localStorage.setItem('disciplinaSelecionada', this.value);
    carregarAlunosSeSelecionado();
});

// Envio do formulário
document.getElementById('formP3').addEventListener('submit', function (e) {
    e.preventDefault();
    const alerta = document.getElementById('alerta');
    alerta.classList.add('d-none');

    const dados = new FormData(this);
    fetch('salvar.php', {
        method: 'POST',
        body: dados
    })
        .then(res => res.json())
        .then(data => {
            alerta.classList.remove('d-none');
            alerta.classList.add(data.sucesso ? 'alert-success' : 'alert-danger');
            alerta.textContent = data.mensagem;
            if (data.sucesso) setTimeout(() => location.reload(), 3000);
        })
        .catch(() => {
            alerta.classList.remove('d-none');
            alerta.classList.add('alert-danger');
            alerta.textContent = 'Erro ao salvar os dados.';
        });
});

// Validação dos campos NT e NS
document.addEventListener('input', function (e) {
    if (e.target.matches('input[name="tarefa[]"], input[name="sala[]"]')) {
        let valor = e.target.value.replace(',', '.');
        const num = parseFloat(valor);

        if (isNaN(num)) {
            e.target.value = '';
            alert("Digite apenas números válidos entre 0 e 10 com até duas casas decimais.");
            return;
        }

        if (num > 10) {
            e.target.value = '10.00';
            alert("O valor não pode ser maior que 10.");
        } else if (num < 0) {
            e.target.value = '0.00';
            alert("O valor não pode ser menor que 0.");
        }

        const decimalPart = valor.split('.')[1];
        if (decimalPart && decimalPart.length > 2) {
            e.target.value = num.toFixed(2);
            alert("Só são permitidas no máximo duas casas decimais.");
        }
    }
});
</script>
</body>
</html>
