<?php
// Define tempo de vida da sessão (12 horas)
ini_set('session.gc_maxlifetime', 43200);
session_set_cookie_params(43200);

// Inicia a sessão
session_start();

// Redireciona se a sessão não estiver definida
if (!isset($_SESSION['idProfessor']) || !isset($_SESSION['nomeProfessor'])) {
    header("Location: https://avilagoiania.kaltekgoiania.com.br/simulados/tarefas/login.php");
    exit;
}

// Armazena os dados da sessão
$id_professor = $_SESSION['idProfessor'];
$nome_professor = $_SESSION['nomeProfessor'];
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <title>TAREFAS TRIMESTRAIS</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0"> 
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
  <style>
    body {
      font-family: Arial, sans-serif;
      background-color: #ffffff;
      margin: 20px;
      color: #000000;
    }

    .container-fluid {
      width: 100%;
    }
    
    h4, h5 {
      margin: 0 0 10px;
    }

    .btn-cadastrar, .filtro-btns {
      margin-left: 15px;
      margin-bottom: 10px;
    }

    .table-responsive-custom {
      overflow-x: auto;
      -webkit-overflow-scrolling: touch;
      margin: 0 15px 20px 15px;
      display: block;
    }

    table {
      white-space: nowrap;
      width: 100%;
      border-collapse: collapse;
      background-color: #ffffff;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
      text-transform: uppercase;
      min-width: 700px;
    }

    th, td {
      padding: 12px 15px;
      text-align: left;
      font-size: 12px;
      border: 1px solid #000;
      vertical-align: middle !important;
    }

    th {
      background-color: #000;
      color: #fff;
    }

    tr:nth-child(even) {
      background-color: #f4f4f4;
    }

    tr:hover {
      background-color: #e0e0e0;
    }

    .mensagem-erro {
      color: red;
      font-size: 11px;
      margin-top: 4px;
      display: none;
    }

    .input-error {
      border: 2px solid red !important;
      background-color: #ffe6e6;
    }
    .input-vermelho {
    color: red;
    }
    
    @media (max-width: 768px) {
      .btn-cadastrar, .filtro-btns .btn {
        width: 100% !important;
        margin: 10px auto;
        font-size: 16px;
        height: 45px;
        padding: 10px 12px;
      }

      .form-group label,
      .form-control {
        font-size: 14px;
      }

      .form-control,
      input[type="text"],
      select {
        height: 40px;
      }

      .table-responsive-custom {
        overflow-x: auto;
        display: block;
      }

      table {
        width: 1000px;
      }

      .table th, .table td {
        min-width: 125px;
        font-size: 14px;
        padding: 8px 10px;
      }

      h4 {
        text-align: center;
      }
      .input-vermelho {
    color: red;
    }
    }
  </style>
</head>
<body>
<div class="container-fluid">
  <h4>NOTA P3 TRIMESTRAL</h4>
  <h5>LEGENDAS</h5>
  <p>MÉDIA POINT = NOTA TAREFAS + POINT / NOTA SIMULADO = NOTA SIMULADO INTERNO / P3 = MEDIA POINT(80%) + NOTA SIMULADO(20%)</p>
  <p>PROFESSOR(A): <?= $nome_professor?></p>
  <button class="btn btn-success" onclick="window.location.href='https://avilagoiania.kaltekgoiania.com.br/simulados/tarefas/'">Voltar para a tela de tarefas</button> <button class="btn btn-success" onclick="window.location.href='https://avilagoiania.kaltekgoiania.com.br/simulados/point/'">Voltar para a tela de Point</button> <button class="btn btn-success" onclick="window.location.href='https://avilagoiania.kaltekgoiania.com.br/simulados/tarefas/logout.php'">sair</button>
  <!--div id="alerta" class="alert d-none"></div-->
  <div class="row">
    <div class="col-md-6">
      <div class="form-group">
        <label for="selectTurma">Selecione a turma:</label>
        <select id="selectTurma" class="form-control text-uppercase" name="turma">
          <option value="">Selecione...</option>
        </select>
      </div>
    </div>
    <div class="col-md-6">
      <div class="form-group">
        <label for="selectTurma2">Selecione uma disciplina:</label>
        <select id="selectTurma2" class="form-control text-uppercase" name="disciplina">
          <option value="">Selecione...</option>
        </select>
      </div>
    </div>
  </div>

  <div id="secaoTabela" style="display: none;" class="table-responsive-custom">
    <form id="formP3">
      <input type="hidden" name="turma" id="inputTurma">
      <input type="hidden" name="disciplina" id="inputDisciplina">

      <table class="table table-bordered">
        <thead>
          <tr>
            <th>Matrícula</th>
            <th>Aluno</th>
            <th>MÉDIA POINT</th><th>NOTA SIMULADO</th><th>NOTA P3</th>
          </tr>
        </thead>
        <tbody></tbody>
      </table>
      <!--button type="submit" class="btn btn-success">Gravar</button-->
    </form>
  </div>
</div>

<script>
function verificaSelecoes() {
  const turma = document.getElementById('selectTurma').value;
  const disciplina = document.getElementById('selectTurma2').value;
  document.getElementById('inputTurma').value = turma;
  document.getElementById('inputDisciplina').value = disciplina;
  document.getElementById('secaoTabela').style.display = (turma && disciplina) ? 'block' : 'none';
}

function carregarTabelaAlunos() {
  const turmaId = document.getElementById('selectTurma').value;
  const disciplinaId = document.getElementById('selectTurma2').value;
  const tbody = document.querySelector('table tbody');
  const alerta = document.getElementById('alerta');

  if (!turmaId || !disciplinaId) {
    verificaSelecoes();
    return;
  }

  fetch(`buscar_alunos.php?id_turma=${turmaId}&id_disciplina=${disciplinaId}`)
    .then(res => res.text())
    .then(data => {
      tbody.innerHTML = data;
      verificaSelecoes();
    })
    .catch(() => {
      alerta.classList.remove('d-none', 'alert-success');
      alerta.classList.add('alert-danger');
      alerta.textContent = 'Erro ao carregar alunos da turma.';
    });
}

document.addEventListener('DOMContentLoaded', () => {
  const turmaSelect = document.getElementById('selectTurma');
  fetch('select.php')
    .then(res => res.json())
    .then(data => {
      data.turmas.forEach(t => {
        turmaSelect.innerHTML += `<option value="${t.id_serie_turma}">${t.identificador_serie} - ${t.identificador_turma} - ${t.identificador_turno}</option>`;
      });

      const turmaSalva = localStorage.getItem('turmaSelecionada');
      if (turmaSalva) {
        turmaSelect.value = turmaSalva;
        atualizarDisciplinas(turmaSalva);
        const disciplinaSalva = localStorage.getItem('disciplinaSelecionada');
        if (disciplinaSalva) {
          setTimeout(() => {
            const disciplinaSelect = document.getElementById('selectTurma2');
            disciplinaSelect.value = disciplinaSalva;
            carregarTabelaAlunos();
          }, 500);
        }
      }
    });
});

document.getElementById('selectTurma').addEventListener('change', function () {
  const turmaId = this.value;
  localStorage.setItem('turmaSelecionada', turmaId);
  atualizarDisciplinas(turmaId);
});

document.getElementById('selectTurma2').addEventListener('change', function () {
  localStorage.setItem('disciplinaSelecionada', this.value);
  carregarTabelaAlunos();
});

function atualizarDisciplinas(turmaId) {
  fetch('select.php?id_turma=' + turmaId)
    .then(res => res.json())
    .then(data => {
      const disciplinaSelect = document.getElementById('selectTurma2');
      disciplinaSelect.innerHTML = '<option value="">Selecione...</option>';
      data.disciplinas.forEach(d => {
        disciplinaSelect.innerHTML += `<option value="${d.id_disciplina}">${d.nomeDisciplina}</option>`;
      });

      const salva = localStorage.getItem('disciplinaSelecionada');
      if (salva && data.disciplinas.some(d => d.id_disciplina === salva)) {
        disciplinaSelect.value = salva;
        carregarTabelaAlunos();
      } else {
        localStorage.removeItem('disciplinaSelecionada');
        disciplinaSelect.value = '';
        document.getElementById('secaoTabela').style.display = 'none';
      }
    });
}

document.getElementById('formP3').addEventListener('submit', function(e) {
  e.preventDefault();
  const alerta = document.getElementById('alerta');
  alerta.classList.add('d-none');

  const inputs = document.querySelectorAll('input[name^="t"]');
  let camposValidos = true;
  inputs.forEach(input => {
    if (!input.value.trim()) {
      input.classList.add('input-error');
      camposValidos = false;
    }
  });
  if (!camposValidos) {
    alerta.classList.remove('d-none');
    alerta.classList.add('alert-danger');
    alerta.textContent = 'Preencha todos os campos antes de salvar.';
    return;
  }

  const dados = new FormData(this);
  fetch('salvar.php', {
    method: 'POST',
    body: dados
  })
    .then(res => res.json())
    .then(data => {
      alerta.classList.remove('d-none');
      alerta.classList.add(data.sucesso ? 'alert-success' : 'alert-danger');
      alerta.textContent = data.mensagem;
      if (data.sucesso) {
        setTimeout(() => {
          location.reload();
        }, 1500);
      }
    })
    .catch(() => {
      alerta.classList.remove('d-none');
      alerta.classList.add('alert-danger');
      alerta.textContent = 'Erro ao salvar os dados.';
    });
});

document.addEventListener('focusout', function (e) {
  const campos = [
    't1[]', 't2[]', 't3[]', 't4[]', 't5[]',
    't6[]', 't7[]', 't8[]', 't9[]', 't10[]', 'point[]'
  ];

  if (campos.includes(e.target.name)) {
    let valor = e.target.value.replace(',', '.');
    let num = parseFloat(valor);

    let mensagem = e.target.nextElementSibling;
    if (!mensagem || !mensagem.classList.contains('mensagem-erro')) {
      mensagem = document.createElement('div');
      mensagem.classList.add('mensagem-erro');
      e.target.parentNode.appendChild(mensagem);
    }

    if (isNaN(num)) {
      e.target.classList.add('input-error');
      mensagem.textContent = "Digite um número válido.";
      mensagem.style.display = 'block';
    } else if (num < 0 || num > 10) {
      e.target.classList.add('input-error');
      mensagem.textContent = "Entre 0 e 10.";
      mensagem.style.display = 'block';
    } else {
      e.target.classList.remove('input-error');
      mensagem.style.display = 'none';
      e.target.value = num.toFixed(2).replace('.', ',');
    }
  }
});
</script>
</body>
</html>
