<?php
header('Content-Type: application/json');

try {
    $pdo = new PDO("mysql:host=localhost;dbname=kaltekgo_avila", "kaltekgo_admin", "kaltek@2024");
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Dados do formulário
    $alunos = $_POST['aluno_id'] ?? [];
    $nomes = $_POST['nome'] ?? [];
    $turmas = $_POST['id_turma'] ?? [];
    $points = $_POST['point'] ?? [];
    $disciplinas = $_POST['disciplina'] ?? [];
    $mts = $_POST['mt'] ?? [];

    // Notas de t1 a t10
    $notas = [];
    for ($i = 1; $i <= 10; $i++) {
        $notas["t{$i}"] = $_POST["t{$i}"] ?? [];
    }

    $check = $pdo->prepare("SELECT COUNT(*) FROM nota_tarefas_entregues WHERE matricula = ? AND id_turma = ? AND id_disciplina = ?");

    $update = $pdo->prepare("
        UPDATE nota_tarefas_entregues SET 
            t1 = ?, t2 = ?, t3 = ?, t4 = ?, t5 = ?,
            t6 = ?, t7 = ?, t8 = ?, t9 = ?, t10 = ?,
            point = ?, nome = ?, id_turma = ?, id_disciplina = ?, mt = ?
        WHERE matricula = ? AND id_turma = ? AND id_disciplina = ?
    ");

    $insert = $pdo->prepare("
        INSERT INTO nota_tarefas_entregues (
            matricula, t1, t2, t3, t4, t5,
            t6, t7, t8, t9, t10, point, nome, id_turma, id_disciplina, mt
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    ");

    for ($i = 0; $i < count($alunos); $i++) {
        $alunoId = $alunos[$i];
        $nome = $nomes[$i] ?? '';
        $turma = $turmas[$i] ?? '';
        $disciplina = $disciplinas[$i] ?? '';
        $mt = floatval(str_replace(',', '.', $mts[$i] ?? 0));
        $point = floatval(str_replace(',', '.', $points[$i] ?? 0));

        // Coletar notas
        $valoresNotas = [];
        for ($j = 1; $j <= 10; $j++) {
            $campo = "t{$j}";
            $valoresNotas[] = floatval(str_replace(',', '.', $notas[$campo][$i] ?? 0));
        }

        $temNota = array_reduce($valoresNotas, fn($carry, $v) => $carry || $v > 0, false) || $point > 0;

        if ($temNota) {
            $check->execute([$alunoId, $turma, $disciplina]);
            $existe = $check->fetchColumn();

            if ($existe) {
                $update->execute([
                    ...$valoresNotas, $point, $nome, $turma, $disciplina, $mt,
                    $alunoId, $turma, $disciplina
                ]);
            } else {
                $insert->execute([
                    $alunoId, ...$valoresNotas, $point, $nome, $turma, $disciplina, $mt
                ]);
            }
        }
    }

    echo json_encode(['sucesso' => true, 'mensagem' => 'Dados salvos com sucesso! Aguarde um momento']);
} catch (Exception $e) {
    echo json_encode(['sucesso' => false, 'mensagem' => 'Erro: ' . $e->getMessage()]);
}
