<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Buscar Notas</title>

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <!-- JQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Bootstrap JS -->
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

    <style>
        body { font-family: Arial; background-color: #fff; margin: 20px; color: #000; }
        table { white-space: nowrap; border-collapse: collapse; width: 100%; background: #fff; text-transform: uppercase; }
        th, td { padding: 8px 12px; text-align: center; }
        td { border: 1px solid #000 !important; }
        th { background: #000; color: #fff; cursor: pointer; }
        tr:nth-child(even) { background: #f4f4f4; }
        tr:hover { background: #e0e0e0; }
        p {text-transform: uppercase;}
    </style>
</head>
<body class="container">

<h4 class="text-left text-uppercase">Busca Individual de Aluno</h4>

<div class="form-group text-uppercase">
    <input type="text" id="busca" class="form-control" placeholder="Digite o nome do aluno">
</div>

<div id="resultado"></div>

<!-- Modal -->
<div class="modal fade" id="modalNT" tabindex="-1" role="dialog" aria-labelledby="modalNTLabel">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title" id="modalNTLabel">Informações da Tarefa</h4>
      </div>
      <div class="modal-body" id="conteudoModalNT">
        Carregando informações...
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
      </div>
    </div>
  </div>
</div>

<script>
$(document).ready(function(){

    // Buscar lista de alunos
    $('#busca').on('input', function(){
        const nome = $(this).val();
        if(nome.length > 0){
            $.ajax({
                url: 'buscar-individual-aluno.php',
                method: 'GET',
                data: { nome },
                dataType: 'json',
                success: mostrarListaAlunos,
                error: function(){ $('#resultado').html('<div class="alert alert-danger">Erro ao buscar dados.</div>'); }
            });
        } else { $('#resultado').html(''); }
    });

    function mostrarListaAlunos(dados){
        $('#resultado').html('');
        if(dados.length === 0){ $('#resultado').html('<div class="alert alert-warning">Nenhum resultado encontrado</div>'); return; }
        let html = '<ul class="list-group">';
        dados.forEach(aluno => {
            html += `<li class="list-group-item" data-matricula="${aluno.matricula}">
                        ${aluno.nome} 
                        <span>(${aluno.matricula})</span> 
                        <span>(${aluno.turma} - ${aluno.nturma})</span>
                     </li>`;
        });
        html += '</ul>';
        $('#resultado').html(html);
    }

    // Clique em aluno → detalhes
    $(document).on('click', '#resultado li', function(){
        const matricula = $(this).data('matricula');
        $.ajax({
            url: 'buscar-individual-aluno.php',
            method: 'GET',
            data: { detalhes: 1, matricula },
            dataType: 'json',
            success: gerarTabela,
            error: function(){ $('#resultado').html('<div class="alert alert-danger">Erro ao carregar detalhes.</div>'); }
        });
    });

    // Gera tabela de notas
    function gerarTabela(aluno){
        $('#resultado').html('');
        let html = `<h5>Aluno: <strong>${aluno.nome}</strong> | Matrícula: <strong>${aluno.matricula}</strong> | Turma: <strong>${aluno.turma} - ${aluno.nturma}</strong> | Turno: <strong>${aluno.turno}</strong></h5>`;
        
        aluno.disciplinas.forEach(disc => {
            const colunas = Object.keys(disc.notas).sort((a, b) => {
    // extrai o número após "t" ou "T", caso a coluna seja t1, t2...
    const numA = parseInt(a.replace(/\D/g,''), 10);
    const numB = parseInt(b.replace(/\D/g,''), 10);
    return numA - numB;
});

            html += `<table class="table table-bordered"><thead>`;
            html += `<tr><th colspan="${colunas.length+3}" class="text-center">${disc.disciplina}</th></tr>`;
            html += `<tr>`;
            colunas.forEach(col => {
    html += `<th 
                data-coluna="${col}" 
                data-turma="${aluno.turma}" 
                data-nturma="${aluno.nturma}"
                data-idturma="${aluno.id_turma}"
                data-disciplina="${disc.disciplina}"  // ❌ Nome da disciplina em vez de ID
            >N${col}</th>`;
});

            
            html += `<th>MT</th><th>SIM</th><th>P3</th></tr></thead><tbody><tr>`;

            // Preenche notas
            let soma = 0;
            colunas.forEach(col => {
                let valor = disc.notas[col] ?? '';
                let valorExibir = valor;
                if(typeof valor==='string' && valor.toUpperCase()==='N') valorExibir='NA';
                else if(typeof valor==='string' && valor.toUpperCase()==='F') valorExibir='A';
                else if(!isNaN(parseFloat(valor))) soma += parseFloat(valor.toString().replace(',', '.'));
                html += `<td>${valorExibir}</td>`;
            });

            // Calcula MT, SM e P3
            const media = colunas.length>0 ? (soma/colunas.length) : 0;
            let peso_mt = aluno.id_turma==43 ? 0.5 : 0.8;
            const mt = media*peso_mt;
            const sm = parseFloat(disc.simulado ?? 0);
            const p3 = mt+sm;

            html += `<td><strong>${mt.toFixed(2).replace('.',',')}</strong></td>`;
            html += `<td><strong>${sm.toFixed(2).replace('.',',')}</strong></td>`;
            html += `<td><strong>${p3.toFixed(2).replace('.',',')}</strong></td>`;
            html += `</tr></tbody></table><br>`;
        });

        html += `<hr>`;
        $('#resultado').append(html);
    }

$(document).on('click', 'th[data-coluna]', function(){
    const coluna = $(this).data('coluna');          
    const disciplina = $(this).data('disciplina');  // nome da disciplina
    const turma = $(this).data('turma');            
    const nturma = $(this).data('nturma');          

    const identificadorTarefa = 'N' + coluna.toUpperCase(); // NT1, NT2...
    const nomeTurma = `${turma} - ${nturma}`;

    // Alerta com os valores enviados
    //alert(`Turma: ${nomeTurma}\nDisciplina: ${disciplina}\nTarefa: ${identificadorTarefa}`);

    $('#modalNTLabel').html(`Detalhes da Tarefa: <strong>${identificadorTarefa}</strong><br><small>Turma: <strong>${nomeTurma}</strong> | Disciplina: <strong>${disciplina}</strong></small>`);
    $('#conteudoModalNT').html('Carregando informações da tarefa...');

    $.ajax({
        url: 'info_tarefas.php',
        method: 'GET',
        dataType: 'json',
        data: {
            nometurma: nomeTurma,        // envia nome da turma
            disciplina: disciplina,      // envia nome da disciplina
            tarefa: identificadorTarefa,
            trimestre: '2º Trimestre'
        },
        success: function(data){
            if(data.erro){
                $('#conteudoModalNT').html('<div class="alert alert-warning">'+data.erro+'</div>');
            } else {
                let html = `
                    <p><strong>Título:</strong> ${data.tituloTarefa}</p>
                    <p><strong>Professor:</strong> ${data.nomeProfessor}</p>
                    <p><strong>Disciplina:</strong> ${data.nomeDisciplina}</p>
                    <p><strong>Turma:</strong> ${data.identificador_turma}</p>
                    <p><strong>Trimestre:</strong> ${data.nomeTrimestre}</p>
                    <p><strong>Data:</strong> ${data.data_tarefa}</p>
                    <p><strong>Tipo:</strong> ${data.tipoTarefa}</p>
                `;
                $('#conteudoModalNT').html(html);
            }
        },
        error: function(){
            $('#conteudoModalNT').html('<div class="alert alert-danger">Erro ao carregar informações.</div>');
        }
    });

    $('#modalNT').modal('show');
});


});
</script>

</body>
</html>
