<?php
header('Content-Type: application/json; charset=utf-8');

// === Conexão com o banco ===
$host = "localhost";
$user = "kaltekgo_admin";
$pass = "kaltek@2024";
$db   = "kaltekgo_avila";

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo json_encode(["erro" => "Falha na conexão: " . $e->getMessage()]);
    exit;
}

// === Parâmetros recebidos ===
$nometurma   = isset($_GET['nometurma']) ? trim($_GET['nometurma']) : '';
$disciplina  = isset($_GET['disciplina']) ? trim($_GET['disciplina']) : '';
$tarefa      = isset($_GET['tarefa']) ? trim($_GET['tarefa']) : '';
$trimestre   = isset($_GET['trimestre']) ? trim($_GET['trimestre']) : '3º Trimestre';

// Validação básica
if ($nometurma == '' || $disciplina == '' || $tarefa == '') {
    echo json_encode([
        "erro" => "Parâmetros inválidos",
        "recebido" => $_GET
    ]);
    exit;
}

// Sanitiza identificador da tarefa e força N maiúsculo
$tarefa_sanitizada = preg_replace('/[^a-zA-Z0-9]/', '', $tarefa);
$identificadorTarefa = strtoupper($tarefa_sanitizada);
if (substr($identificadorTarefa, 0, 1) !== 'N') {
    $identificadorTarefa = 'N' . $identificadorTarefa;
}

// === Query para buscar a tarefa ===
$sql = "
    SELECT 
        tituloTarefa,
        identificador_turma,
        nomeTrimestre,
        nomeProfessor,
        nomeDisciplina,
        identificadorTarefa,
        data_tarefa,
        tipoTarefa
    FROM tarefas_cadastradas
    WHERE identificador_turma LIKE ?
      AND nomeDisciplina = ?
      AND nomeTrimestre = ?
      AND identificadorTarefa = ?
    LIMIT 1
";

$stmt = $pdo->prepare($sql);
$stmt->execute(["%$nometurma%", $disciplina, $trimestre, $identificadorTarefa]);
$tarefaInfo = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$tarefaInfo) {
    echo json_encode([
        "erro" => "Nenhuma tarefa encontrada",
        "nometurma" => $nometurma,
        "disciplina" => $disciplina,
        "trimestre" => $trimestre,
        "identificadorTarefa" => $identificadorTarefa
    ]);
    exit;
}

// === Retorno final ===
echo json_encode($tarefaInfo, JSON_UNESCAPED_UNICODE);
exit;
?>
