<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <title>Consulta de Notas</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { padding: 20px; }
    #listaAlunos li { cursor: pointer; }
    #listaAlunos li:hover { background: #f0f0f0; }
  </style>
</head>
<body>
  <div class="container">
    <h2 class="mb-4">Pesquisar Aluno</h2>
    <div class="mb-3 d-flex">
      <input type="text" id="buscaNome" class="form-control me-2" placeholder="Digite o nome do aluno">
      <button class="btn btn-primary" onclick="buscarNomes()">Buscar</button>
    </div>

    <ul id="listaAlunos" class="list-group mb-4"></ul>

    <div id="detalhesAluno" class="d-none">
      <h4 id="tituloAluno"></h4>
      <div class="table-responsive">
        <table class="table table-bordered mt-3">
          <thead class="table-light">
            <tr>
              <th>Disciplina</th>
              <th>Notas</th>
            </tr>
          </thead>
          <tbody id="tabelaNotas"></tbody>
        </table>
      </div>
    </div>
  </div>

  <script>
    function buscarNomes() {
      const nome = document.getElementById("buscaNome").value;
      document.getElementById("listaAlunos").innerHTML = "";
      document.getElementById("detalhesAluno").classList.add("d-none");

      fetch("buscar.php?nome=" + encodeURIComponent(nome))
        .then(r => r.json())
        .then(data => {
          if (data.length === 0) {
            document.getElementById("listaAlunos").innerHTML = "<li class='list-group-item'>Nenhum aluno encontrado</li>";
            return;
          }
          data.forEach(aluno => {
            const li = document.createElement("li");
            li.className = "list-group-item";
            li.textContent = aluno.nome + " (" + aluno.matricula + ")";
            li.onclick = () => carregarDetalhes(aluno.matricula);
            document.getElementById("listaAlunos").appendChild(li);
          });
        });
    }

    function carregarDetalhes(matricula) {
      fetch("buscar.php?detalhes=1&matricula=" + encodeURIComponent(matricula))
        .then(r => r.json())
        .then(aluno => {
          document.getElementById("detalhesAluno").classList.remove("d-none");
          document.getElementById("tituloAluno").textContent =
            aluno.nome + " (" + aluno.matricula + ") - Turma: " + aluno.turma;

          const tbody = document.getElementById("tabelaNotas");
          tbody.innerHTML = "";

          aluno.disciplinas.forEach(d => {
            const tr = document.createElement("tr");

            const tdDisc = document.createElement("td");
            tdDisc.textContent = d.disciplina;

            const tdNotas = document.createElement("td");
            tdNotas.textContent = Object.values(d.notas).join(", ");

            tr.appendChild(tdDisc);
            tr.appendChild(tdNotas);
            tbody.appendChild(tr);
          });
        });
    }
  </script>
</body>
</html>
