<?php
$id_turma = $_GET['id_turma'];
require 'vendor/autoload.php'; // Certifique-se de que o DOMPDF está instalado

use Dompdf\Dompdf;

// Configuração do banco de dados
$host = 'localhost';
$dbname = 'kaltekgo_avila';
$username = 'kaltekgo_admin';
$password = 'kaltek@2024';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Erro ao conectar ao banco de dados: " . $e->getMessage());
}

// Consulta ao banco de dados
$sql = "SELECT matricula, nome, nota, nota2,  turma, desempenho FROM simulado_geral WHERE id_turma = :id_turma ORDER BY nome ASC";
$stmt = $pdo->prepare($sql);
$stmt->execute(['id_turma' => $id_turma]);
$dados = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Obter a turma para o cabeçalho
$turma = !empty($dados) ? htmlspecialchars($dados[0]['turma']) : 'Desconhecida';

// Construção do HTML para o PDF
$html = '
    <style>
       @import url("https://fonts.googleapis.com/css2?family=Barlow:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&display=swap");
        
        body {
            font-family: "Roboto", sans-serif;
            font-weight: 400;
            font-style: normal;
            background-color: #DFF5E1; /* Verde pastel */
            margin: 20px;
            
        }
        
        h1, h2, h3, h4, h5 {
            text-align: left;
            margin-bottom: 20px;
            margin-top: -20px;
            color: #000000;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        
        table, th, td {
            border: 1px solid #000000;
        }
        
        th, td {
            padding: 5px;
            text-align: left;
            font-size: 12px;
            color: #000000;
            
        }
        
        th {
            background-color: #9ACD9A;
            color: #000000;
            text-transform: uppercase;
        }
        
        td {
            color: #000000;
            text-transform: uppercase;
        }
    </style>
';

$html .= '<h5>SIMULADO 1º TRIMESTRE</h5>';
$html .= '<h5>RELATÓRIO DE DESEMPENHO</h5>';
$html .= '<h5>SÉRIE/TURMA: '. $turma .'</h5>';
$html .= '<table>';
$html .= '<thead><tr><th>Matrícula</th><th>Série/Turma</th><th>Nome</th><th>Nota(obt)</th><th>Nota(cons)</th></tr></thead>';
$html .= '<tbody>';

// Montar as linhas da tabela
if (!empty($dados)) {
    foreach ($dados as $dado) {
        $html .= '<tr>';
        $html .= '<td>' . htmlspecialchars($dado['matricula']) . '</td>';
        $html .= '<td>' . htmlspecialchars($dado['turma']) . '</td>';
        $html .= '<td>' . htmlspecialchars($dado['nome']) . '</td>';
        $html .= '<td>' . number_format($dado['desempenho'], 2, ',', '') . '</td>';
        $total = $dado['nota']+$dado['nota2'];
        $html .= '<td>' . number_format($total, 2, ',', '') . '</td>';
        $html .= '</tr>';
    }
} else {
    $html .= '<tr><td colspan="3">Nenhum dado encontrado para a turma selecionada.</td></tr>';
}

$html .= '</tbody></table>';

// Configurar DOMPDF
$dompdf = new Dompdf();
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();

// Enviar o PDF para download
$dompdf->stream("Relatório Desempenho - ". $turma .".pdf", ["Attachment" => false]);
?>
