<?php
session_start();

// Conexão com banco
$pdo = new PDO("mysql:host=localhost;dbname=kaltekgo_avila", "kaltekgo_admin", "kaltek@2024");
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// Sessão
$id_professor = $_SESSION['idProfessor'] ?? 0;
$nome_professor = $_SESSION['nomeProfessor'] ?? '';
$tipoUsuario = $_SESSION['tipoUsuario'] ?? '';

// Parâmetros recebidos
$id_turma = $_GET['id_turma'] ?? '';
$id_disciplina = $_GET['id_disciplina'] ?? '';
$trimestre = $_GET['trimestre'] ?? 3;

// Busca total de tarefas cadastradas
$totalTarefas = 0;
if ($id_turma && $id_disciplina && $id_professor && $trimestre) {
if ($tipoUsuario === 'coordenador') {
    // Coordenador vê todas as tarefas
    $stmt = $pdo->prepare("
        SELECT COUNT(*) AS total_tarefas
        FROM tarefas_cadastradas
        WHERE id_turma = :turma 
          AND idDisciplina = :disciplina 
          AND idTrimestre = :trimestre
    ");
    $stmt->execute([
        ':turma' => $id_turma,
        ':disciplina' => $id_disciplina,
        ':trimestre' => $trimestre
    ]);
} else {
    // Professor vê apenas suas tarefas
    $stmt = $pdo->prepare("
        SELECT COUNT(*) AS total_tarefas
        FROM tarefas_cadastradas
        WHERE id_turma = :turma 
          AND idProfessor = :professor 
          AND idDisciplina = :disciplina 
          AND idTrimestre = :trimestre
    ");
    $stmt->execute([
        ':turma' => $id_turma,
        ':professor' => $id_professor,
        ':disciplina' => $id_disciplina,
        ':trimestre' => $trimestre
    ]);
}

    $resultado = $stmt->fetch(PDO::FETCH_ASSOC);
    $totalTarefas = $resultado['total_tarefas'] ?? 0;
}

// Função para formatar nota
function formatarNota($valor) {
    if ($valor == 10) return '10';
    elseif (fmod($valor, 1) == 0.0) return number_format($valor, 1, ',', '');
    else return rtrim(rtrim(number_format($valor, 2, ',', ''), '0'), ',');
}
function formatarNotaTarefa($valor) {
    if ($valor == '0') return '';
    if ($valor == 10) return '10';
    elseif (fmod($valor, 1) == 0.0) return number_format($valor, 1, ',', '');
    else return rtrim(rtrim(number_format($valor, 2, ',', ''), '0'), ',');
}

// Buscar alunos
$alunos = [];
if ($id_turma && $id_disciplina) {
    $stmt = $pdo->prepare("
        SELECT 
            nota_tarefas_entregues.*, 
            simulado_geral.nome, 
            simulado_geral.matricula, 
            simulado_geral.nota,
            simulado_geral.nota2,
            simulado_geral.id_turma
        FROM simulado_geral
        LEFT JOIN nota_tarefas_entregues 
            ON simulado_geral.matricula = nota_tarefas_entregues.matricula
            AND nota_tarefas_entregues.id_turma = ?
            AND nota_tarefas_entregues.id_disciplina = ?
            AND nota_tarefas_entregues.idTrimestre = ?
        WHERE simulado_geral.id_turma = ? 
        ORDER BY simulado_geral.nome ASC
    ");
    $stmt->execute([$id_turma, $id_disciplina, $trimestre, $id_turma]);
    $alunos = $stmt->fetchAll(PDO::FETCH_ASSOC);
}

?>

<?php foreach ($alunos as $aluno): 
    $somaNotas = 0;
?>
<tr>
    <td style="width: 50px;">
        <strong><?= htmlspecialchars($aluno['matricula']) ?></strong>
        <input type="hidden" name="aluno_id[]" value="<?= $aluno['matricula'] ?>">
        <input type="hidden" name="id_turma[]" value="<?= $aluno['id_turma'] ?>">
        <input type="hidden" name="disciplina[]" value="<?= $id_disciplina ?>">
    </td>
    <td>
        <strong><?= htmlspecialchars($aluno['nome']) ?></strong>
        <input type="hidden" name="nome[]" value="<?= $aluno['nome'] ?>">
    </td>

    <?php for ($i = 1; $i <= $totalTarefas; $i++):
        $notaOriginal = $aluno["t{$i}"] ?? '';
$somaNotas += is_numeric($notaOriginal) ? floatval($notaOriginal) : 0;

        $somaNotas += $nota;
    ?>
        <td>
    <input type="text text-uppercase" name="t<?= $i ?>[]" class="form-control campo" style="width:60px"
        value="<?= is_numeric($notaOriginal) ? formatarNotaTarefa(floatval($notaOriginal)) : htmlspecialchars($notaOriginal) ?>">
</td>


    <?php endfor; ?>

<?php
if ($id_turma == 43) {
    $peso_mt = 0.5;
    $peso_simulado = 0.5;

    // Soma os dois simulados
    $simulado = (floatval($aluno['nota']) + floatval($aluno['nota2'])) * $peso_simulado;
    //$simulado = 0;
} else {
    $peso_mt = 0.8;
   
    // Apenas simulado1
    $simulado = floatval($aluno['nota']*0.2);
    //$simulado = 0;
}

// Média de tarefas
$media_tarefas = ($totalTarefas > 0) ? ($somaNotas / $totalTarefas) : 0;
$mt = $media_tarefas * $peso_mt;

// Cálculo final
$p3 = $mt + $simulado;
?>


    <td><input type="text" name="mt[]" class="form-control campo <?= $mt < 0 ? 'input-vermelho' : '' ?>" 
        value="<?= formatarNota($mt) ?>" style="width:60px" readonly></td>
    <td><input type="text" name="simulado[]" class="form-control campo <?= $simulado < 1 ? 'input-vermelho' : '' ?>" 
        value="<?= formatarNota($simulado) ?>" style="width:60px" readonly></td>
    <td><input type="text" name="p3[]" class="form-control campo <?= $p3 < 7 ? 'input-vermelho' : '' ?>" 
        value="<?= formatarNota($p3) ?>" style="width:60px" readonly></td>
</tr>
<?php endforeach; ?>
