<!doctype html>
<html lang="pt-br">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Modal com redirecionamento</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<!-- Modal -->
<div class="modal fade" id="infoModal" tabindex="-1" aria-labelledby="infoModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="infoModalLabel">Informação rápida</h5>
      </div>
      <div class="modal-body">
        <p>
          <strong>0 a 10</strong> — para aluno que apresentou a tarefa.<br>
          Coloque  — <strong>F</strong> — para aluno ausente no dia da apresentação da tarefa.<br>
          Coloque  — <strong>N</strong> — para aluno que não apresentou ou não fez a tarefa.
        </p>
        <p class="text-muted">Fechando em <span id="countdown">5</span> segundos...</p>
      </div>
      <div class="modal-footer">
        <button type="button" id="closeBtn" class="btn btn-secondary">Fechar agora</button>
      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
  const countdownEl = document.getElementById('countdown');
  const closeBtn = document.getElementById('closeBtn');
  let seconds = 10;

  const myModal = new bootstrap.Modal(document.getElementById('infoModal'));
  myModal.show();

  const timer = setInterval(() => {
    seconds--;
    countdownEl.textContent = seconds;
    if (seconds <= 0) {
      clearInterval(timer);
      myModal.hide();
    }
  }, 1000);

  closeBtn.addEventListener('click', () => {
    myModal.hide();
  });

  document.getElementById('infoModal').addEventListener('hidden.bs.modal', () => {
    window.location.href = 'index.php';
  });
});
</script>
</body>
</html>
