<?php
header('Content-Type: application/json');

// === DEBUG inicial: salvar tudo que chegou via POST ===
file_put_contents('debug_post.txt', print_r($_POST, true), FILE_APPEND);

try {
    $pdo = new PDO("mysql:host=localhost;dbname=kaltekgo_avila", "kaltekgo_admin", "kaltek@2024");
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $alunos      = $_POST['aluno_id']   ?? [];
    $nomes       = $_POST['nome']       ?? [];
    $turmas      = $_POST['id_turma']   ?? [];
    $points      = $_POST['point']      ?? [];
    $disciplinas = $_POST['disciplina'] ?? [];
    $idTrimestre = $_POST['trimestre']  ?? 3;
    $mts         = $_POST['mt']         ?? [];

    // Notas t1..t30
    $notas = [];
    for ($i = 1; $i <= 30; $i++) {
        $notas["t{$i}"] = $_POST["t{$i}"] ?? [];
    }

    $check = $pdo->prepare("SELECT COUNT(*) 
                            FROM nota_tarefas_entregues 
                            WHERE matricula = ? AND id_turma = ? AND id_disciplina = ? AND idTrimestre = ?");

    $camposUpdate = [];
    for ($i = 1; $i <= 30; $i++) {
        $camposUpdate[] = "t{$i} = ?";
    }

    $updateSQL = "
        UPDATE nota_tarefas_entregues SET 
            " . implode(', ', $camposUpdate) . ",
            point = ?, nome = ?, id_turma = ?, id_disciplina = ?, mt = ?
        WHERE matricula = ? AND id_turma = ? AND id_disciplina = ? AND idTrimestre = ?
    ";
    $update = $pdo->prepare($updateSQL);

   $camposInsert = implode(', ', array_map(function($i) {
    return "t{$i}";
}, range(1, 30)));

    $placeholders = rtrim(str_repeat('?, ', 30), ', ');
    $insertSQL = "
        INSERT INTO nota_tarefas_entregues (
            matricula, $camposInsert, point, nome, id_turma, id_disciplina, mt, idTrimestre
        ) VALUES (?, $placeholders, ?, ?, ?, ?, ?, ?)
    ";
    $insert = $pdo->prepare($insertSQL);

    $erros = []; // <-- Armazena erros por aluno

    for ($i = 0; $i < count($alunos); $i++) {
        $alunoId    = $alunos[$i];
        $nome       = $nomes[$i] ?? '';
        $turma      = $turmas[$i] ?? '';
        $disciplina = $disciplinas[$i] ?? '';
        $mt         = floatval(str_replace(',', '.', $mts[$i] ?? 0));
        $point      = floatval(str_replace(',', '.', $points[$i] ?? 0));

        $valoresNotas = [];
        for ($j = 1; $j <= 30; $j++) {
            $campo = "t{$j}";
            $valorBruto = trim($notas[$campo][$i] ?? '');
            $valorNormalizado = strtoupper($valorBruto);

            if (in_array($valorNormalizado, ['F', 'N', 'A'])) {
                $valoresNotas[] = $valorNormalizado;
            } elseif (is_numeric(str_replace(',', '.', $valorBruto))) {
                $valoresNotas[] = number_format(floatval(str_replace(',', '.', $valorBruto)), 2, '.', '');
            } else {
                $valoresNotas[] = null;
            }
        }

        $temNota = array_reduce($valoresNotas, function($carry, $v) {
            return $carry || (is_numeric($v) && floatval($v) > 0) || in_array($v, ['F', 'N']);
        }, false) || $point > 0;

        if ($temNota) {
            $check->execute([$alunoId, $turma, $disciplina, $idTrimestre]);
            $existe = $check->fetchColumn();

            try {
                if ($existe) {
                    $update->execute([
                        ...$valoresNotas, $point, $nome, $turma, $disciplina, $mt,
                        $alunoId, $turma, $disciplina, $idTrimestre
                    ]);
                } else {
                    $insert->execute([
                        $alunoId, ...$valoresNotas, $point, $nome, $turma, $disciplina, $mt, $idTrimestre
                    ]);
                }
            } catch (Exception $e) {
                // Salva o erro individual em arquivo e em memória
                $msgErro = "Erro ao salvar aluno {$alunoId} ({$nome}): " . $e->getMessage();
                file_put_contents("debug_erro_aluno_{$alunoId}.txt", $msgErro . "\nSQL: " . ($existe ? 'UPDATE' : 'INSERT'));
                $erros[] = $msgErro;
            }
        }
    }

    if (count($erros) > 0) {
        echo json_encode([
            'sucesso' => false,
            'mensagem' => '❌ Alguns registros não foram salvos.',
            'detalhes' => $erros
        ]);
    } else {
        echo json_encode([
            'sucesso' => true,
            'mensagem' => '✅ Todos os dados foram salvos com sucesso!'
        ]);
    }

} catch (Exception $e) {
    file_put_contents('debug_erro_geral.txt', $e->getMessage() . "\n" . $e->getTraceAsString());
    echo json_encode(['sucesso' => false, 'mensagem' => '❌ Erro geral: ' . $e->getMessage()]);
}
