<?php
session_start();

// Conexão com banco
$pdo = new PDO("mysql:host=localhost;dbname=kaltekgo_avila", "kaltekgo_admin", "kaltek@2024");
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// Sessão
$id_professor = $_SESSION['idProfessor'] ?? 0;
$nome_professor = $_SESSION['nomeProfessor'] ?? '';

// Parâmetros recebidos
$id_turma = $_GET['id_turma'] ?? '';
$id_disciplina = $_GET['id_disciplina'] ?? '';
$trimestre = $_GET['trimestre'] ?? 2;

// Busca total de tarefas cadastradas
$totalTarefas = 0;
if ($id_turma && $id_disciplina && $id_professor && $trimestre) {
    $stmt = $pdo->prepare("
        SELECT COUNT(*) AS total_tarefas
        FROM tarefas_cadastradas
        WHERE id_turma = :turma 
          AND idProfessor = :professor 
          AND idDisciplina = :disciplina 
          AND idTrimestre = :trimestre
    ");
    $stmt->execute([
        ':turma' => $id_turma,
        ':professor' => $id_professor,
        ':disciplina' => $id_disciplina,
        ':trimestre' => $trimestre
    ]);
    $resultado = $stmt->fetch(PDO::FETCH_ASSOC);
    $totalTarefas = $resultado['total_tarefas'] ?? 0;
}

// Função para formatar nota
function formatarNota($valor) {
    if ($valor == 10) return '10';
    elseif (fmod($valor, 1) == 0.0) return number_format($valor, 1, ',', '');
    else return rtrim(rtrim(number_format($valor, 2, ',', ''), '0'), ',');
}

// Buscar alunos
$alunos = [];
if ($id_turma && $id_disciplina) {
    $stmt = $pdo->prepare("
        SELECT 
            nota_tarefas_entregues.*, 
            simulado_geral.nome, 
            simulado_geral.matricula, 
            simulado_geral.nota,
            simulado_geral.id_turma
        FROM simulado_geral
        LEFT JOIN nota_tarefas_entregues 
            ON simulado_geral.matricula = nota_tarefas_entregues.matricula
            AND nota_tarefas_entregues.id_turma = ?
            AND nota_tarefas_entregues.id_disciplina = ?
        WHERE simulado_geral.id_turma = ?
    ");
    $stmt->execute([$id_turma, $id_disciplina, $id_turma]);
    $alunos = $stmt->fetchAll(PDO::FETCH_ASSOC);
}
?>

<?php foreach ($alunos as $aluno): 
    $somaNotas = 0;
?>
<tr>
    <td style="width: 50px;">
        <strong><?= htmlspecialchars($aluno['matricula']) ?></strong>
        <input type="hidden" name="aluno_id[]" value="<?= $aluno['matricula'] ?>">
        <input type="hidden" name="id_turma[]" value="<?= $aluno['id_turma'] ?>">
        <input type="hidden" name="disciplina[]" value="<?= $id_disciplina ?>">
    </td>
    <td>
        <strong><?= htmlspecialchars($aluno['nome']) ?></strong>
        <input type="hidden" name="nome[]" value="<?= $aluno['nome'] ?>">
    </td>

    <?php for ($i = 1; $i <= $totalTarefas; $i++):
        $nota = floatval($aluno["t{$i}"] ?? 0);
        $somaNotas += $nota;
    ?>
        <td>
            <input type="text" name="t<?= $i ?>[]" class="form-control campo" style="width:60px"
                value="<?= formatarNota($nota) ?>" min="0" max="10" step="0.1">
        </td>
    <?php endfor; ?>

    <?php
        $mt = ($totalTarefas > 0) ? (($somaNotas / $totalTarefas) * 0.8) : 0;
        $simulado = floatval($aluno['nota']) * 0.2;
        $p3 = $mt + $simulado;
    ?>

    <td><input type="text" name="mt[]" class="form-control campo <?= $mt < 7 ? 'input-vermelho' : '' ?>" 
        value="<?= formatarNota($mt) ?>" style="width:60px" readonly></td>
    <td><input type="text" name="simulado[]" class="form-control campo <?= $simulado < 1 ? 'input-vermelho' : '' ?>" 
        value="<?= formatarNota($simulado) ?>" style="width:60px" readonly></td>
    <td><input type="text" name="p3[]" class="form-control campo <?= $p3 < 7 ? 'input-vermelho' : '' ?>" 
        value="<?= formatarNota($p3) ?>" style="width:60px" readonly></td>
</tr>
<?php endforeach; ?>
