<?php
session_start();

// Simulação das sessões (remova em produção)
$idprofessor = $_SESSION['idProfessor'];
$nomeProfessor = $_SESSION['nomeProfessor'];

$pdo = new PDO("mysql:host=localhost;dbname=kaltekgo_avila", "kaltekgo_admin", "kaltek@2024");
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// Inserção no banco
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $titulo = $_POST['tituloTarefa'];
    $id_turma = $_POST['id_turma'];
    $identificador_turma = $_POST['identificador_turma'];
    $trimestre = $_POST['id_trimestre'];
    $nome_trimestre = $_POST['nome_trimestre'];
    $id_disciplina = $_POST['idDisciplina'];
    $id_professor = $_POST['id_professor'];
    $nome_professor = $_POST['nome_professor'];
    $nome_disciplina = $_POST['nome_disciplina'];

    $stmt = $pdo->prepare("INSERT INTO tarefas_cadastradas 
        (tituloTarefa, id_turma, identificador_turma, idTrimestre, nomeTrimestre, idProfessor, nomeProfessor, idDisciplina, nomeDisciplina)
        VALUES (:titulo, :id_turma, :identificador_turma, :trimestre, :nome_trimestre, :id_professor, :nome_professor, :id_disciplina, :nome_disciplina)");
    
    $stmt->execute([
        ':titulo' => $titulo,
        ':id_turma' => $id_turma,
        ':identificador_turma' => $identificador_turma,
        ':trimestre' => $trimestre,
        ':nome_trimestre' => $nome_trimestre,
        ':id_professor' => $id_professor,
        ':nome_professor' => $nome_professor,
        ':id_disciplina' => $id_disciplina,
        ':nome_disciplina' => $nome_disciplina
    ]);

    echo "<div class='alert alert-success text-center' id='mensagem'>Tarefa cadastrada com sucesso!</div>";
}

?>

<!DOCTYPE html>
<html>
<head>
    <title>Cadastrar Tarefa</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
</head>
<body style="background-color: #ffffff;">
    <div class="container">
        <div class="row" style="margin-top: 60px;">
            <div class="col-md-8 col-md-offset-2">
                <div class="panel panel-default">
                    <div class=" text-center">
                        <h3>Cadastrar Tarefa</h3>
                    </div>
                    <div class="panel-body">
                        <form method="post">

    <div class="form-group">
        <label for="tituloTarefa">Título da Tarefa</label>
        <input type="text" name="tituloTarefa" id="tituloTarefa" class="form-control" required>
    </div>

    <div class="form-group">
        <label for="id_turma">Turma</label>
        <select name="id_turma" id="id_turma" class="form-control" required>
            <option value="">Selecione a turma</option>
            <?php
            $idProfessor = $_SESSION['idProfessor'];
            $turmas = $pdo->query("SELECT DISTINCT id_turma, nomeTurma FROM disciplinaProfessor WHERE id_professor = '$idProfessor'")->fetchAll();
            foreach ($turmas as $turma) {
                echo "<option value='{$turma['id_turma']}' data-nome='{$turma['nomeTurma']}'>{$turma['nomeTurma']}</option>";
            }
            ?>
        </select>
    </div>

    <div class="form-group">
        <label for="trimestre">Trimestre</label>
        <select name="id_trimestre" id="id_trimestre" class="form-control" required>
            <option value="">Escola um Trimestre</option>
            <!--option value="1">1º Trimestre</option-->
            <option value="2">2º Trimestre</option>
            <!--option value="3">3º Trimestre</option-->
        </select>
    </div>

    <div class="form-group">
        <label for="idDisciplina">Disciplina</label>
        <select name="idDisciplina" id="idDisciplina" class="form-control" required>
            <option value="">Selecione a turma primeiro</option>
        </select>
    </div>

    <!-- Hidden fields -->
    <input type="hidden" name="identificador_turma" id="identificador_turma">
    <input type="hidden" name="nome_trimestre" id="nome_trimestre">
    <input type="hidden" name="id_professor" value="<?php echo $_SESSION['idProfessor']; ?>">
    <input type="hidden" name="nome_professor" value="<?php echo $_SESSION['nomeProfessor']; ?>">
    <input type="hidden" name="nome_disciplina" id="nome_disciplina">

    <button type="submit" class="btn btn-success btn-block">Cadastrar Tarefa</button>
    <a href="https://avilagoiania.kaltekgoiania.com.br/simulados/tarefas/index.php" class="btn btn-default btn-block" style="margin-top: 10px;">Voltar</a>

</form>

                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- Scripts -->
    <script>
        document.getElementById('id_turma').addEventListener('change', function () {
            const turmaId = this.value;
            const nomeTurma = this.options[this.selectedIndex].dataset.nome;
            document.getElementById('identificador_turma').value = nomeTurma;

            // AJAX para buscar disciplinas
            const xhr = new XMLHttpRequest();
            xhr.open("GET", "buscar_disciplinas.php?id_turma=" + turmaId, true);
            xhr.onload = function () {
                if (xhr.status === 200) {
                    const select = document.getElementById('idDisciplina');
                    select.innerHTML = '<option value="">Selecione a disciplina</option>' + xhr.responseText;
                    document.getElementById('nome_disciplina').value = '';
                }
            };
            xhr.send();
        });

        document.getElementById('id_trimestre').addEventListener('change', function () {
            const nome = this.options[this.selectedIndex].text;
            document.getElementById('nome_trimestre').value = nome;
        });

        document.getElementById('idDisciplina').addEventListener('change', function () {
            const nome = this.options[this.selectedIndex].dataset.nome;
            document.getElementById('nome_disciplina').value = nome;
        });
        
        setTimeout(function () {
        const msg = document.getElementById('mensagem');
        if (msg) {
            msg.style.display = 'none';
        }
    }, 3000);
    </script>
</body>
</html>
