<?php
session_start();
if (!isset($_SESSION['idProfessor'])) {
    echo json_encode(['total' => 0]);
    exit;
}

$pdo = new PDO("mysql:host=localhost;dbname=kaltekgo_avila", "kaltekgo_admin", "kaltek@2024");
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

$id_turma = $_GET['id_turma'] ?? null;
$id_disciplina = $_GET['id_disciplina'] ?? null;
$id_professor = $_SESSION['idProfessor'];
$trimestre = $_GET['trimestre'] ?? 2; // padrão trimestre 2

$totalTarefas = 0;

if ($id_turma && $id_disciplina) {
    $stmt = $pdo->prepare("
        SELECT COUNT(*) AS total_tarefas
        FROM tarefas_cadastradas
        WHERE id_turma = :turma 
          AND idProfessor = :professor 
          AND idDisciplina = :disciplina 
          AND idTrimestre = :trimestre
    ");
    $stmt->execute([
        ':turma' => $id_turma,
        ':professor' => $id_professor,
        ':disciplina' => $id_disciplina,
        ':trimestre' => $trimestre
    ]);
    $resultado = $stmt->fetch(PDO::FETCH_ASSOC);
    $totalTarefas = $resultado['total_tarefas'] ?? 0;
}

echo json_encode(['total' => $totalTarefas]);
