<?php
$user = 'usuario-teste';
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Colégio Ávila</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            margin: 0;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            height: 100vh;
            background-color: #fff;
            color: #000;
        }
        .grid-container {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            grid-template-rows: auto;
            width: 60%;
            max-width: 1200px;
        }
        .grid-item {
            display: flex;
            justify-content: center;
            align-items: center;
            background-color: #fff;
            color: #000;
            font-size: 1.2rem;
            font-weight: bold;
            border-radius: 5px;
            text-align: center;
            padding: 10px;
            margin-right: 0; /* Define a distância entre colunas */
        }
        .grid-item:nth-child(3n) {
            margin-right: 0; /* Remove o espaçamento da última coluna */
        }
        .btn-success {
            font-size: 1rem;
            width: 275px;
        }
        @media (max-width: 768px) {
            .grid-container {
                grid-template-columns: repeat(1, 1fr);
                width: 100%;
            }
            .grid-item {
                margin-right: 0; /* Ajuste para colunas únicas */
            }
        }
        p {
            color: #000000;
            text-align: left; /* Alinha o texto à esquerda */
            width: 60%; /* Garante que ocupe todo o espaço horizontal */
            padding: 0 20px; /* Adiciona espaçamento à esquerda e direita */
        }
    </style>
</head>
<body>
    <p>Seja bem-vindo, <strong><?php echo $user; ?></strong>.</p>
    <div class="grid-container">
        <div class="grid-item">
            <a href="https://avilagoiania.kaltekgoiania.com.br/sistema/user/">
                <button class="btn btn-success">Requisições de Equipamentos</button>
            </a>
        </div>
        <div class="grid-item">
            <a href="https://avilagoiania.kaltekgoiania.com.br/sistema/user/relatorioGeral.php">
                <button class="btn btn-success">Relatório de Compras</button>
            </a>
        </div>
        <div class="grid-item">
            <a href="https://avilagoiania.kaltekgoiania.com.br/sistema/user/valorGeral.php">
                <button class="btn btn-success">Valor Geral</button>
            </a>
        </div>
        <div class="grid-item">
            <a href="https://avilagoiania.kaltekgoiania.com.br/sistema/user/relatorioEquipamentos.php">
                <button class="btn btn-success">Equipamentos</button>
            </a>
        </div>
        <div class="grid-item"></div>
        <div class="grid-item"></div>
        <div class="grid-item"></div>
    </div>
</body>
</html>
