<?php
$departamento = 'tecnologia';
$usuario = 'Christopher';
include 'db.php';

// Definir o número de registros por página
$limit = 15;

// Verificar qual é a página atual
$page = isset($_GET['page']) ? $_GET['page'] : 1;

// Calcular o ponto de partida para a consulta SQL
$start = ($page - 1) * $limit;

// Recuperar o número total de registros
$sql_count = "SELECT COUNT(*) AS total FROM requisicao";
$result_count = $conn->query($sql_count);
$total_count = $result_count->fetch_assoc()['total'];

// Calcular o número total de páginas
$total_pages = ceil($total_count / $limit);

// Recupera os pedidos com limite e ordenação
$sql = "SELECT * FROM requisicao WHERE departamento = '$departamento' ORDER BY data_requisicao DESC LIMIT $start, $limit";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Requisições</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
	<style>
	.button{
            margin-top: 2px;
          }	
	</style>
</head>
<body>
    <div class="container mt-5">
        <h1 class="text-center">Requisições</h1>
        <a href="novaRequisicao.php" class="btn btn-success mb-3">Nova Requisição</a><p class="text-end">Olá, <strong><?php echo $usuario ?></strong></p>

        <!-- Tabela de pedidos -->
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Requisição</th>
                    <th>Data do Pedido</th>
		            <th>Status do Pedido</th>
                    <th>Autorizado por</th>
                    <th>Ações</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($result->num_rows > 0): ?>
                    <?php while ($row = $result->fetch_assoc()): ?>
                        <tr>
                            <td><small><?php echo $row['codigo']; ?></small></td>
							
                            <?php 
                            $data = $row['data_requisicao']; 
                            date_default_timezone_set('America/Sao_Paulo'); 
                            
                            // Convert the date string into a timestamp
                            $timestamp = strtotime($data); 
                            
                            // Format the timestamp
                            $date = date('d/m/Y H:i:s', $timestamp); 
                            ?>
                            <td style="width:250px;" class="text-uppercase"><small><?php echo $row['titulo_requisicao']; ?></small></td>
                            <td><small><?php echo $date; ?></small></td>
                            <td class="text-uppercase"><small><?php echo $row['status']; ?></small></td>
                            <td class="text-uppercase"><small><?php echo $row['autorizado_por']; ?></small></td>
                            <td>
                                <a href="visualizarRequisicao.php?codigo=<?php echo $row['codigo']; ?>&requisicao=<?php echo $row['titulo_requisicao']; ?>" class="btn btn-primary btn-sm">Visualizar</a>
                                <a href="deleteRequisicao.php?codigo=<?php echo $row['codigo']; ?>" class="btn btn-danger btn-sm button">Excluir</a>
                                <a href="../pedidos/pdf/index.php?codigo=<?php echo $row['codigo']; ?>&titulo_requisicao=<?php echo $row['titulo_requisicao']; ?>&data_pedido=<?php echo $row['data_requisicao']; ?>" class="btn btn-success btn-sm button" target="_blank">Imprimir</a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="7">Nenhum pedido encontrado.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>

        <!-- Paginação -->
        <nav>
            <ul class="pagination justify-content-center">
                <li class="page-item <?php if ($page <= 1) { echo 'disabled'; } ?>">
                    <a class="page-link" href="?page=<?php echo $page - 1; ?>">Anterior</a>
                </li>
                <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                    <li class="page-item <?php if ($i == $page) { echo 'active'; } ?>">
                        <a class="page-link" href="?page=<?php echo $i; ?>"><?php echo $i; ?></a>
                    </li>
                <?php endfor; ?>
                <li class="page-item <?php if ($page >= $total_pages) { echo 'disabled'; } ?>">
                    <a class="page-link" href="?page=<?php echo $page + 1; ?>">Próxima</a>
                </li>
            </ul>
        </nav>
    </div>
</body>
</html>

<?php $conn->close(); ?>