<?php
date_default_timezone_set('America/Sao_Paulo');

// Recebe os parâmetros da requisição
$data = filter_input(INPUT_GET, 'data_pedido', FILTER_SANITIZE_STRING);
$codigo = filter_input(INPUT_GET, 'codigo', FILTER_SANITIZE_STRING);
$titulo_requisicao = filter_input(INPUT_GET, 'titulo_requisicao', FILTER_SANITIZE_STRING);

// Configurações do banco de dados
$servidor = "localhost";
$usuario = "kaltekgo_admin";
$senha = "kaltek@2024";
$dbname = "kaltekgo_avila";

// Conexão com o banco
$conn = mysqli_connect($servidor, $usuario, $senha, $dbname);
if (!$conn) {
    die("Falha na conexão: " . mysqli_connect_error());
}

// Converte a data para o formato desejado
$timestamp = strtotime($data);
$data = date('d/m/Y H:i', $timestamp);

// Carrega o autoload do DOMPDF
require 'vendor/autoload.php';

use Dompdf\Dompdf;

$dompdf = new Dompdf();
$dompdf->set_option('isRemoteEnabled', true);

// Inicia o HTML do PDF
$html = '
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Requisição de Equipamentos</title>
    <style>
        body { font-family: Arial, sans-serif; }
        .logo { width: 100px; position: absolute; top: -20px; right: 20px; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        table, th, td { border: 1px solid black; }
        th, td { padding: 10px; text-align: left; font-size: 12px; }
        .right-align { text-align: right; }
        .signature { margin-top: 50px; text-align: right; }
        .uppercase { text-transform: uppercase; }
    </style>
</head>
<body>
    <img src="https://colegioavila.com.br/wp-content/uploads/2019/02/logo-chanfrado01.png" class="logo" alt="Logo">
    <h2>Requisição de Equipamentos</h2>
    <p>Nº Requisição: ' . htmlspecialchars($codigo) . '</p>
    <p>Requisição: <span class="uppercase">' . htmlspecialchars($titulo_requisicao) . '</span></p>
    <p class="right-align"><strong>Data do Pedido:</strong> ' . $data . '</p>
    <table>
        <thead>
            <tr>
                <th>Qtd</th>
                <th>Item (Descrição)</th>
                <th class="right-align">Valor Unitário (R$)</th>
                <th class="right-align">Valor Total (R$)</th>
            </tr>
        </thead>
        <tbody>';

// Inicializa os totais
$valor_total = 0;
$valor_frete = 0;

// Consulta os dados do pedido
$sql = "SELECT * FROM pedidos 
        INNER JOIN frete ON pedidos.codigo = frete.codigo 
        INNER JOIN requisicao ON requisicao.codigo = pedidos.codigo 
        WHERE frete.codigo = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $codigo);
$stmt->execute();
$result = $stmt->get_result();

while ($row = $result->fetch_assoc()) {
    $valor_total_itens = $row['quantidade'] * $row['valor_unitario'];
    $valor_total += $valor_total_itens;
    $valor_frete = $row['valor_frete'];
    $status = $row['status'];
    $autorizado = $row['autorizado_por'];

    // Formatação de valores
    $valor_unitario_formatado = number_format($row['valor_unitario'], 2, ',', '.');
    $valor_total_itens_formatado = number_format($valor_total_itens, 2, ',', '.');

    $html .= '<tr>
                <td>' . $row['quantidade'] . '</td>
                <td class="uppercase">' . htmlspecialchars($row['descricao']) . '</td>
                <td class="right-align">' . $valor_unitario_formatado . '</td>
                <td class="right-align">' . $valor_total_itens_formatado . '</td>
              </tr>';
}

$stmt->close();
$conn->close();

// Totais finais
$valor_total_formatado = number_format($valor_total, 2, ',', '.');
$valor_frete_formatado = number_format($valor_frete, 2, ',', '.');
$valor_total_com_frete = $valor_total + $valor_frete;
$valor_total_com_frete_formatado = number_format($valor_total_com_frete, 2, ',', '.');

$html .= '<tr>
            <td colspan="3" class="right-align"><strong>Total:</strong></td>
            <td class="right-align"><strong>R$ ' . $valor_total_formatado . '</strong></td>
          </tr>';
$html .= '</tbody>
    </table>
    <p class="right-align"><strong>Valor do Frete:</strong> R$ ' . $valor_frete_formatado . '</p>
    <p class="right-align"><strong>Valor Total:</strong> R$ ' . $valor_total_com_frete_formatado . '</p>
    <p class="signature">
        <strong>' . htmlspecialchars($status) . ' por<br>
        <span class="uppercase">' . htmlspecialchars($autorizado) . '</span></strong><br><br><!--
        _________________________________<br>
        Ass.--><br><br>
        Data documento: ' . date('d/m/Y H:i:s') . '
    </p>
</body>
</html>';

// Gera o PDF
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();
$dompdf->stream("$titulo_requisicao.pdf", ["Attachment" => false]);
