<?php
date_default_timezone_set('America/Sao_Paulo');

$ano = '2025';
$mes = '01';

// Configurações do banco de dados
$servidor = "localhost";
$usuario = "kaltekgo_admin";
$senha = "kaltek@2024";
$dbname = "kaltekgo_avila";

// Conexão com o banco
$conn = mysqli_connect($servidor, $usuario, $senha, $dbname);
if (!$conn) {
    die("Falha na conexão: " . mysqli_connect_error());
}

// Carrega o autoload do DOMPDF
require 'vendor/autoload.php';

use Dompdf\Dompdf;

// Cria uma instância do DOMPDF
$dompdf = new Dompdf();
$dompdf->set_option('isRemoteEnabled', true);

// Consulta para unir as tabelas
$sql = "SELECT * FROM pedidos p JOIN requisicao r ON p.codigo = r.codigo LEFT JOIN frete f ON r.codigo = f.codigo WHERE status = 'aprovado' AND DATE_FORMAT(data_pedido, '%Y-%m') = '$ano-$mes' ORDER BY data_pedido DESC";
$result = mysqli_query($conn, $sql);

// Inicia o HTML do PDF
$html = '
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Requisições de Equipamentos</title>
    <style>
        body { font-family: Arial, sans-serif; }
        .logo { width: 100px; position: absolute; top: -20px; right: 20px; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        table, th, td { border: 1px solid black; }
        th, td { padding: 10px; text-align: left; font-size: 12px; }
        .right-align { text-align: right; }
        .uppercase { text-transform: uppercase; }
        .signature { margin-top: 50px; text-align: right; }
    </style>
</head>
<body>
    <img src="https://colegioavila.com.br/wp-content/uploads/2019/02/logo-chanfrado01.png" class="logo" alt="Logo">
    <h2>Relatório de Requisições de Equipamentos</h2>
    <table>
        <thead>
            <tr>
                <th>Nº Requisição</th>
                <th>Título</th>
                <th>Data do Pedido</th>
                <th>Qtd</th>
                <th>Item (Descrição)</th>
                <th class="right-align">Valor Unitário (R$)</th>
                <th class="right-align">Valor Total (R$)</th>
                <th class="right-align">Frete (R$)</th>
                <th>Status</th>
                <th>Autorizado Por</th>
            </tr>
        </thead>
        <tbody>';

// Inicializa os totais
$valor_total_geral = 0;

while ($row = mysqli_fetch_assoc($result)) {
    // Calcula os valores
    $valor_total_itens = $row['quantidade'] * $row['valor_unitario'];
    $valor_frete = $row['valor_frete'] ?? 0;
    $valor_total_geral += $valor_total_itens + $valor_frete;

    // Formatações
    $data_pedido_formatada = date('d/m/Y H:i', strtotime($row['data_pedido']));
    $valor_unitario_formatado = number_format($row['valor_unitario'], 2, ',', '.');
    $valor_total_itens_formatado = number_format($valor_total_itens, 2, ',', '.');
    $valor_frete_formatado = number_format($valor_frete, 2, ',', '.');

    // Adiciona os dados no HTML
    $html .= '<tr>
                <td>' . htmlspecialchars($row['codigo']) . '</td>
                <td class="uppercase">' . htmlspecialchars($row['titulo_requisicao']) . '</td>
                <td>' . $data_pedido_formatada . '</td>
                <td>' . $row['quantidade'] . '</td>
                <td class="uppercase">' . htmlspecialchars($row['descricao']) . '</td>
                <td class="right-align">' . $valor_unitario_formatado . '</td>
                <td class="right-align">' . $valor_total_itens_formatado . '</td>
                <td class="right-align">' . $valor_frete_formatado . '</td>
                <td class="uppercase">' . htmlspecialchars($row['status']) . '</td>
                <td class="uppercase">' . htmlspecialchars($row['autorizado_por']) . '</td>
              </tr>';
}

// Total Geral
$valor_total_geral_formatado = number_format($valor_total_geral, 2, ',', '.');

$html .= '<tr>
            <td colspan="9" class="right-align"><strong>Total Geral:</strong></td>
            <td class="right-align"><strong>R$ ' . $valor_total_geral_formatado . '</strong></td>
          </tr>';
$html .= '</tbody>
    </table>
    <p class="signature">Gerado em: ' . date('d/m/Y H:i:s') . '</p>
</body>
</html>';

// Fecha a conexão com o banco
mysqli_close($conn);

// Gera o PDF
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'landscape');
$dompdf->render();
$dompdf->stream("requisicoes_equipamentos.pdf", ["Attachment" => false]);
