<?php
$user = 'usuario-teste';
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Relatório de Equipamentos</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            margin: 0;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            height: 100vh;
            background-color: #fff;
            color: #000;
        }
        .grid-container {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            grid-template-rows: auto;
            width: 100%;
            max-width: 1200px;
        }
        .grid-item {
            display: flex;
            justify-content: center;
            align-items: center;
            background-color: #fff;
            color: #000;
            font-size: 1.2rem;
            font-weight: bold;
            border-radius: 5px;
            text-align: center;
            padding: 10px;
        }
        .btn-success {
            font-size: 1rem;
            width: 275px;
        }
        @media (max-width: 768px) {
            .grid-container {
                grid-template-columns: repeat(1, 1fr);
            }
        }
        @media (max-width: 480px) {
            .grid-container {
                grid-template-columns: repeat(1, 1fr);
            }
        }
        p {
            color: #000000;
            text-align: left;
            width: 85%;
            padding: 0 0px;
        }
        table {
            border-collapse: collapse;
            width: 100%;
            text-align: left;
        }
        th, td {
            border: 1px solid #000; /* Borda preta de 1px */
            padding: 8px;
            font-size: 12px;
        }
        th {
            background-color: #f2f2f2;
        }
    </style>
</head>
<body>
    <p><h3>Relatório de Equipamentos</h3></p>
    <div class="grid-container">
<?php
            // Conexão com o banco de dados
            $servername = "localhost";
            $username = "kaltekgo_admin";
            $password = "kaltek@2024";
            $dbname = "kaltekgo_avila";

            // Criando conexão
            $conn = new mysqli($servername, $username, $password, $dbname);

            // Checando conexão
            if ($conn->connect_error) {
                die("Conexão falhou: " . $conn->connect_error);
            }

            // Consulta SQL
            $sql = "SELECT * FROM equipamentos ";

            // Inicializa o valor total
            $result = $conn->query($sql); 
            // Verifica se retornou resultados
            if ($result->num_rows > 0) {
                // Exibindo cada linha de dados
                while($row = $result->fetch_assoc()) {
                echo "<div class='grid-item'>";
                   echo "<table>";
                   echo "<thead>";
                   echo "<tr>";
                   echo "<th class='text-uppercase'>Código</th>";
                   echo "<th class='text-uppercase'>Descrição do Equipamento</th>";
                   echo "<th class='text-uppercase'>Local do Equipamento</th>";
                   echo "</tr>";
                   echo "</thead>";
                   echo "<tbody>";
                   echo "<tr>";
                   echo "<td class='text-uppercase' data-label=''>" . $row['id_codigo'] . "</td>";
                   echo "<td class='text-uppercase' data-label=''>" . $row['descricao'] . "</td>";
                   echo "<td class='text-uppercase' data-label=''>" . $row['local'] . "</td>";
                   echo "</tr>";
                   echo "</tbody>";
                   echo "</table>";
                   echo "</div>";
                }
            } else {
                echo "<tr><td colspan='4'>Nenhum resultado encontrado</td></tr>";
            }

            // Fechando conexão
            $conn->close();
            ?>            
        
    </div>
</body>
</html>
