<?php
date_default_timezone_set('America/Sao_Paulo');

// Configurações do banco de dados
$servidor = "localhost";
$usuario = "kaltekgo_admin";
$senha = "kaltek@2024";
$dbname = "kaltekgo_avila";

// Conexão com o banco
$conn = mysqli_connect($servidor, $usuario, $senha, $dbname);
if (!$conn) {
    die("Falha na conexão: " . mysqli_connect_error());
}

// Configuração de paginação
$registros_por_pagina = 5;
$pagina_atual = isset($_GET['pagina']) ? (int)$_GET['pagina'] : 1;
$offset = ($pagina_atual - 1) * $registros_por_pagina;

// Consulta para unir as tabelas com limite e offset
$sql = "SELECT * FROM pedidos p 
        JOIN requisicao r ON p.codigo = r.codigo 
        LEFT JOIN frete f ON r.codigo = f.codigo 
        WHERE status = 'aprovado' 
        ORDER BY data_pedido DESC 
        LIMIT $registros_por_pagina OFFSET $offset";
$result = mysqli_query($conn, $sql);

// Consulta para obter o número total de registros
$sql_total = "SELECT COUNT(*) as total FROM pedidos p 
              JOIN requisicao r ON p.codigo = r.codigo 
              WHERE status = 'aprovado'";
$result_total = mysqli_query($conn, $sql_total);
$total_registros = mysqli_fetch_assoc($result_total)['total'];
$total_paginas = ceil($total_registros / $registros_por_pagina);

// Inicializa os totais
$valor_total_geral = 0;
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Requisições de Equipamentos</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .logo {
            width: 150px;
            position: absolute;
            top: -10px;
            right: 20px;
        }
        .uppercase {
            text-transform: uppercase;
        }
        .right-align {
            text-align: right;
        }
        .signature {
            margin-top: 50px;
            text-align: right;
        }
        .pagination {
            justify-content: center;
        }
    </style>
</head>
<body>
    <div class="container mt-5">
        <h2 class="mb-4">Requisições de Equipamentos</h2>
        <div class="table-responsive">
            <table class="table table-bordered table-striped">
                <thead class="table-dark">
                    <tr>
                        <th>Nº Requisição</th>
                        <th>Título</th>
                        <th>Data do Pedido</th>
                        <th>Qtd</th>
                        <th>Item (Descrição)</th>
                        <th class="right-align">Valor Unitário (R$)</th>
                        <th class="right-align">Valor Total (R$)</th>
                        <th class="right-align">Frete (R$)</th>
                        <th>Status</th>
                        <th>Autorizado Por</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = mysqli_fetch_assoc($result)): 
                        $valor_total_itens = $row['quantidade'] * $row['valor_unitario'];
                        $valor_frete = $row['valor_frete'] ?? 0;
                        $valor_total_geral += $valor_total_itens + $valor_frete;

                        $data_pedido_formatada = date('d/m/Y H:i', strtotime($row['data_pedido']));
                        $valor_unitario_formatado = number_format($row['valor_unitario'], 2, ',', '.');
                        $valor_total_itens_formatado = number_format($valor_total_itens, 2, ',', '.');
                        $valor_frete_formatado = number_format($valor_frete, 2, ',', '.');
                    ?>
                    <tr>
                        <td><?= htmlspecialchars($row['codigo']) ?></td>
                        <td class="uppercase"><?= htmlspecialchars($row['titulo_requisicao']) ?></td>
                        <td><?= $data_pedido_formatada ?></td>
                        <td><?= $row['quantidade'] ?></td>
                        <td class="uppercase"><?= htmlspecialchars($row['descricao']) ?></td>
                        <td class="right-align"><?= $valor_unitario_formatado ?></td>
                        <td class="right-align"><?= $valor_total_itens_formatado ?></td>
                        <td class="right-align"><?= $valor_frete_formatado ?></td>
                        <td class="uppercase"><?= htmlspecialchars($row['status']) ?></td>
                        <td class="uppercase"><?= htmlspecialchars($row['autorizado_por']) ?></td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
        <nav>
            <ul class="pagination">
                <?php for ($i = 1; $i <= $total_paginas; $i++): ?>
                    <li class="page-item <?= $i == $pagina_atual ? 'active' : '' ?>">
                        <a class="page-link" href="?pagina=<?= $i ?>"><?= $i ?></a>
                        
                    </li>
                <?php endfor; ?>
               
            </ul>
          <center><a href="../"><button type="button" class="btn btn-military-green btn-sm">Voltar</button></center>   
        </nav>
        
        <!--p class="signature">Gerado em: <?//= date('d/m/Y H:i:s') ?></p-->
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

<?php
// Fecha a conexão com o banco
mysqli_close($conn);
?>
