<?php
date_default_timezone_set('America/Sao_Paulo');

// Configuração do banco de dados
$servidor = "localhost";
$usuario = "kaltekgo_admin";
$senha = "kaltek@2024";
$dbname = "kaltekgo_avila";

// Conexão com o banco
$conn = mysqli_connect($servidor, $usuario, $senha, $dbname);
if (!$conn) {
    die("Falha na conexão: " . mysqli_connect_error());
}

// Definir mês e ano desejados (modifique conforme necessário)
$mes = isset($_GET['mes']) ? $_GET['mes'] : date('m'); // Mês atual por padrão
$ano = isset($_GET['ano']) ? $_GET['ano'] : date('Y'); // Ano atual por padrão

// Configuração de paginação
$registros_por_pagina = 5;
$pagina_atual = isset($_GET['pagina']) ? (int)$_GET['pagina'] : 1;
$offset = ($pagina_atual - 1) * $registros_por_pagina;

// Consulta SQL para buscar registros do mês/ano específico
$sql = "SELECT * FROM pedidos p 
        JOIN requisicao r ON p.codigo = r.codigo 
        LEFT JOIN frete f ON r.codigo = f.codigo 
        WHERE status = 'aprovado' 
        AND DATE_FORMAT(data_pedido, '%Y-%m') = '$ano-$mes'
        ORDER BY data_pedido DESC 
        LIMIT $registros_por_pagina OFFSET $offset";
$result = mysqli_query($conn, $sql);

// Consulta para obter o número total de registros
$sql_total = "SELECT COUNT(*) as total FROM pedidos p 
              JOIN requisicao r ON p.codigo = r.codigo 
              WHERE status = 'aprovado'
              AND DATE_FORMAT(data_pedido, '%Y-%m') = '$ano-$mes'";
$result_total = mysqli_query($conn, $sql_total);
$total_registros = mysqli_fetch_assoc($result_total)['total'];
$total_paginas = ceil($total_registros / $registros_por_pagina);
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Requisições de Equipamentos</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .pagination {
            justify-content: center;
        }
    </style>
</head>
<body>
    <div class="container mt-5">
        <h2 class="mb-4">Requisições de Equipamentos - <?= "$mes/$ano" ?></h2>
        
        <!-- Formulário para Selecionar o Mês e Ano -->
        <form method="GET" class="mb-3">
            <label>Selecione o Mês:</label>
            <select name="mes">
                <?php for ($m = 1; $m <= 12; $m++): 
                    $mes_formatado = str_pad($m, 2, '0', STR_PAD_LEFT); ?>
                    <option value="<?= $mes_formatado ?>" <?= ($mes_formatado == $mes) ? 'selected' : '' ?>>
                        <?= $mes_formatado ?>
                    </option>
                <?php endfor; ?>
            </select>
            
            <label>Ano:</label>
            <select name="ano">
                <?php for ($y = 2020; $y <= date('Y'); $y++): ?>
                    <option value="<?= $y ?>" <?= ($y == $ano) ? 'selected' : '' ?>><?= $y ?></option>
                <?php endfor; ?>
            </select>
            
            <button type="submit" class="btn btn-primary">Filtrar</button>
        </form>

        <div class="table-responsive">
            <table class="table table-bordered table-striped">
                <thead class="table-dark">
                    <tr>
                        <th>Nº Requisição</th>
                        <th>Título</th>
                        <th>Data do Pedido</th>
                        <th>Qtd</th>
                        <th>Item (Descrição)</th>
                        <th>Valor Unitário (R$)</th>
                        <th>Valor Total (R$)</th>
                        <th>Frete (R$)</th>
                        <th>Status</th>
                        <th>Autorizado Por</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = mysqli_fetch_assoc($result)): ?>
                    <tr>
                        <td><?= htmlspecialchars($row['codigo']) ?></td>
                        <td><?= htmlspecialchars($row['titulo_requisicao']) ?></td>
                        <td><?= date('d/m/Y H:i', strtotime($row['data_pedido'])) ?></td>
                        <td><?= $row['quantidade'] ?></td>
                        <td><?= htmlspecialchars($row['descricao']) ?></td>
                        <td>R$ <?= number_format($row['valor_unitario'], 2, ',', '.') ?></td>
                        <td>R$ <?= number_format($row['quantidade'] * $row['valor_unitario'], 2, ',', '.') ?></td>
                        <td>R$ <?= number_format($row['valor_frete'] ?? 0, 2, ',', '.') ?></td>
                        <td><?= htmlspecialchars($row['status']) ?></td>
                        <td><?= htmlspecialchars($row['autorizado_por']) ?></td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>

        <nav>
            <ul class="pagination">
                <?php for ($i = 1; $i <= $total_paginas; $i++): ?>
                    <li class="page-item <?= $i == $pagina_atual ? 'active' : '' ?>">
                        <a class="page-link" href="?pagina=<?= $i ?>&mes=<?= $mes ?>&ano=<?= $ano ?>"><?= $i ?></a>
                    </li>
                <?php endfor; ?>
            </ul>
        </nav>

        <!-- Botão para gerar PDF -->
        <a href="gerar_pdf.php?mes=<?= $mes ?>&ano=<?= $ano ?>" class="btn btn-danger">Exportar para PDF</a>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

<?php
mysqli_close($conn);
?>
