<?php
date_default_timezone_set('America/Sao_Paulo');

// Configurações do banco de dados
$servidor = "localhost";
$usuario = "kaltekgo_admin";
$senha = "kaltek@2024";
$dbname = "kaltekgo_avila";

// Conexão com o banco
$conn = mysqli_connect($servidor, $usuario, $senha, $dbname);
if (!$conn) {
    die("Falha na conexão: " . mysqli_connect_error());
}

// Definir mês e ano desejados
$mes = '02'; // Janeiro
$ano = '2025'; // Ano específico

// Consulta para unir as tabelas e filtrar por mês e ano
$sql = "SELECT * FROM pedidos p 
        JOIN requisicao r ON p.codigo = r.codigo 
        LEFT JOIN frete f ON r.codigo = f.codigo 
        WHERE status = 'aprovado' 
        AND DATE_FORMAT(data_pedido, '%Y-%m') = '$ano-$mes'
        ORDER BY data_pedido DESC";
$result = mysqli_query($conn, $sql);

// Inicializa os totais
$valor_total_geral = 0;
?>
<?php 
while ($row = mysqli_fetch_assoc($result)): 
    $valor_total_itens = $row['quantidade'] * $row['valor_unitario'];
    $valor_frete = $row['valor_frete'] ?? 0;
    $valor_total_geral += $valor_total_itens + $valor_frete;

    $data_pedido_formatada = date('d/m/Y H:i', strtotime($row['data_pedido']));
    $valor_unitario_formatado = number_format($row['valor_unitario'], 2, ',', '.');
    $valor_total_itens_formatado = number_format($valor_total_itens, 2, ',', '.');
    $valor_frete_formatado = number_format($valor_frete, 2, ',', '.');
?>
<?php endwhile; ?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Requisições de Equipamentos</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .center-content {
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }
        .button-like {
            display: inline-block;
            padding: 10px 20px;
            background-color: #28a745;
            color: white;
            font-size: 1.2rem;
            font-weight: bold;
            border-radius: 50px;
            text-decoration: none;
            text-align: center;
        }
        .button-like:hover {
            background-color: #28a745;
        }
        .font {
            font-size: 0.9rem;
        }
    </style>
</head>
<body>
    <div class="container center-content">
        <h5 class="text-uppercase font">Valor total de gastos</h5>
        <h5 class="text-uppercase font">Departamento de TI</h5>
        <h5 class="button-like">R$ <?= number_format($valor_total_geral, 2, ',', '.') ?></h5>
        <a href="../"><button type="button" class="btn btn-military-green btn-sm">Voltar</button>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php
// Fecha a conexão com o banco
mysqli_close($conn);
?>
