<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>TUTOR MUNDI</title>
  <style>
    body {
      display: flex;
      justify-content: center;
      align-items: center;
      min-height: 100vh;
      margin: 0;
      font-family: Arial, sans-serif;
      background-color: #f4f4f4;
    }
    .container {
      display: grid;
      grid-template-columns: repeat(3, 1fr);
      grid-gap: 40px;
      width: 100%;
      max-width: 1200px;
      padding-left: 10px;
    }
    .column {
      text-align: center;
      padding: 15px;
      border-radius: 5px;
      box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
      width: 350px;
    }
    label {
      display: block;
      margin-bottom: 5px;
      font-weight: bold;
      text-align: left;
    }
    input,
    select {
      width: 95%;
      padding: 8px;
      border: 1px solid #ccc;
      border-radius: 5px;
    }
    .error {
      color: red;
      font-size: 0.9em;
      margin-top: 5px;
      display: none;
    }
    .button-container {
      margin-top: 20px;
      text-align: center;
      grid-column: span 3; /* Faz o botão ocupar toda a largura do formulário */
    }
    button {
      background-color: green;
      color: white;
      padding: 10px 20px;
      border: none;
      border-radius: 5px;
      cursor: pointer;
    }
    button:hover {
      background-color: darkgreen;
    }
    select, option{
        text-transform: uppercase;
    }

    /* Media query para dispositivos móveis */
    @media (max-width: 768px) {
      .container {
        grid-template-columns: 1fr;
      }
      img {
        display: block;
        margin: 0 auto;
        width: 40%;
        margin-top: 20px;
      }
      button {
        margin-bottom: 15px;
      }
      h2 {
        text-align: center;
      }
    }
  </style>
</head>
<body>
  <div>
    <img src="LOGO_COLÉGIO ÁVILA_PNG-VERDE.png" width="200px">
    <h2 style="padding-left: 10px; text-transform: uppercase;">CADASTRO TUTOR MUNDI</h2>
    <form action="inserirBd.php" method="POST">
      <div class="container">
        <!-- Linha 1 -->
        <div class="column">
          <label for="nomeAluno">Nome Aluno</label>
          <input type="text" id="nomeAluno" placeholder="Digite seu nome" name="nomeAluno" required>
        </div>
        <div class="column">
          <label for="emailAluno">Email do Aluno</label>
          <input type="email" id="emailAluno" placeholder="Digite seu email" name="emailAluno" required>
        </div>
        <div class="column">
          <label for="telefoneAluno">Telefone do Aluno</label>
          <input type="text" id="telefoneAluno" placeholder="(XX) XXXXX-XXXX" maxlength="14" name="telefoneAluno" required>
          <span class="error" id="errorTelefoneAluno">Número inválido!</span>
        </div>
        <!-- Linha 2 -->
        <div class="column">
          <label for="nomeResponsavel">Nome Responsável</label>
          <input type="text" id="nomeResponsavel" placeholder="Digite o nome do responsável" name="nomeResponsavel" required>
        </div>
        <div class="column">
          <label for="emailResponsavel">Email do Responsável</label>
          <input type="email" id="emailResponsavel" placeholder="Digite seu email" name="emailResponsavel" required>
        </div>
        <div class="column">
          <label for="telefoneResponsavel">Telefone do Responsável</label>
          <input type="text" id="telefoneResponsavel" placeholder="(XX) XXXXX-XXXX" maxlength="14" name="telefoneResponsavel" required>
          <span class="error" id="errorTelefoneResponsavel">Número inválido!</span>
        </div>
        <!-- Linha 3 -->
        <div class="column">
          <label for="serieTurma">Série/Turma</label>
          <select id="serieTurma" name="serieTurmaTurno">
           <!--option value="">ESCOLHA UMA OPÇÃO</option-->   
            <?php
            // Conexão com o banco de dados
            $conn = new mysqli("localhost", "kaltekgo_admin", "kaltek@2024", "kaltekgo_avila");

            // Verificar se a conexão foi bem-sucedida
            if ($conn->connect_error) {
                die("Erro na conexão: " . $conn->connect_error);
            }

            // Query para buscar séries/turmas
            $sql = "SELECT * FROM serie_turma_turno WHERE id_ensino='2'";
            $result = $conn->query($sql);

            // Verificar se há resultados
            if ($result->num_rows > 0) {
                while ($row = $result->fetch_assoc()) {
                    echo '<option value="' . $row["id_serie_turma"] . '">' . $row["identificador_serie"] . ' - ' . $row["identificador_turma"] . ' - ' . $row["identificador_turno"] . '</option>';
                }
            } else {
                echo '<option value="">Nenhuma opção disponível</option>';
            }

            // Fechar conexão
            $conn->close();
            ?>
          </select>
        </div>
      </div>
      <div class="button-container">
        <button type="submit">SALVAR</button>
      </div>
    </form>
  </div>
</body>
</html>
<script>
    // Função para aplicar máscara e validação em tempo real
    function applyPhoneMaskAndValidation(inputId, errorId) {
      const phoneInput = document.getElementById(inputId);
      const errorSpan = document.getElementById(errorId);

      phoneInput.addEventListener('input', (event) => {
        let value = event.target.value.replace(/\D/g, ''); // Remove caracteres não numéricos
        value = value.replace(/^(\d{2})(\d)/, '($1) $2'); // Adiciona parênteses para o DDD
        value = value.replace(/(\d{5})(\d{4})$/, '$1-$2'); // Adiciona o hífen no número
        event.target.value = value;

        // Verifica se o valor possui um formato de telefone válido
        const phoneRegex = /^\(\d{2}\) \d{5}-\d{4}$/; // Formato (XX) XXXXX-XXXX

        if (phoneRegex.test(event.target.value)) {
          phoneInput.style.borderColor = 'black'; // Borda preta quando o telefone for válido
          errorSpan.style.display = 'none'; // Esconde a mensagem de erro
        } else {
          phoneInput.style.borderColor = 'red'; // Borda vermelha quando o telefone for inválido
          errorSpan.style.display = 'block'; // Mostra a mensagem de erro
        }
      });
    }

    // Aplicar máscara e validação nos telefones
    applyPhoneMaskAndValidation('telefoneAluno', 'errorTelefoneAluno');
    applyPhoneMaskAndValidation('telefoneResponsavel', 'errorTelefoneResponsavel');

    // Validação básica para email
    function validateEmail(inputId) {
      const emailInput = document.getElementById(inputId);
      emailInput.addEventListener('input', (event) => {
        const emailValue = event.target.value;
        const emailRegex = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/;
        if (emailRegex.test(emailValue)) {
          emailInput.style.borderColor = 'black'; // Borda preta quando o email for válido
        } else {
          emailInput.style.borderColor = 'red'; // Indica erro visualmente
        }
      });
    }

    // Validar emails
    validateEmail('emailAluno');
    validateEmail('emailResponsavel');
  </script>
