<?php
// Conexão com o banco de dados (substitua pelos seus dados)
$servername = "localhost";
$username = "kaltekgo_admin";
$password = "kaltek@2024";
$database = "kaltekgo_avila";

$conn = new mysqli($servername, $username, $password, $database);

// Verificar conexão
if ($conn->connect_error) {
    die("Falha na conexão: " . $conn->connect_error);
}

// Consulta SQL para buscar os dados
$sql = "SELECT 
    dados_alunos_para_cadastro.id,
    dados_alunos_para_cadastro.nomeAluno,
    dados_alunos_para_cadastro.nomeResponsavel,
    dados_alunos_para_cadastro.emailAluno,
    dados_alunos_para_cadastro.emailResponsavel,
    dados_alunos_para_cadastro.telefoneAluno,
    dados_alunos_para_cadastro.telefoneResponsavel,
    dados_alunos_para_cadastro.data_criacao_cadastro,
    serie_turma_turno.identificador_serie,
    serie_turma_turno.identificador_turma,
    serie_turma_turno.identificador_turno
FROM 
    dados_alunos_para_cadastro
INNER JOIN 
    serie_turma_turno 
ON 
    dados_alunos_para_cadastro.id_serie_turma = serie_turma_turno.id_serie_turma
WHERE 
    dados_alunos_para_cadastro.id_serie_turma != 43
ORDER BY 
    dados_alunos_para_cadastro.data_criacao_cadastro DESC, 
    dados_alunos_para_cadastro.nomeAluno ASC;
";

$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Tabela de Alunos Tutor Mundi</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 5px;
        }
        h1 {
            text-align: center;
            color: #333;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
            background: #fff;
        }
        table th, table td {
            border: 1px solid #ddd;
            padding: 4px;
            text-align: left;
            font-size: 11px;
        }
        table th {
            background-color: #4CAF50;
            color: white;
        }
        table tr:nth-child(even) {
            background-color: #f2f2f2;
        }
        table tr:hover {
            background-color: #ddd;
        }
    </style>
</head>
<body>
<div class="container mt-4">
    <h2 class="mb-3">Lista de Alunos</h2>
    <table class="table table-striped table-hover sm">
        <thead class="table-dark">
            <tr>
                <th>Nome do Aluno</th>
                <th>Email do Aluno</th>
                <th>Celular do Aluno</th>
                <th>Nome do Responsável</th>
                <th>Email do Responsável</th>
                <th>Celular do Responsável</th>
                <th>Unidade</th>
                <th>Série do Aluno</th>
                <th>Turma do Aluno</th>
                <th>Data Cadastro</th>
            </tr>
        </thead>
        <tbody>
            <?php
            if ($result->num_rows > 0) {
                while ($row = $result->fetch_assoc()) {
                     // Formatar a data para dd/mm/yyyy
                    $dataCadastro = date('d/m/Y H:i:s', strtotime($row["data_criacao_cadastro"]));
                    echo "<tr>
                            <td>{$row['nomeAluno']}</td>
                            <td>{$row['emailAluno']}</td>
                            <td>{$row['telefoneAluno']}</td>
                            <td>{$row['nomeResponsavel']}</td>
                            <td>{$row['emailResponsavel']}</td>
                            <td>{$row['telefoneResponsavel']}</td>
                            <td>Goiânia</td>
                            <td>{$row['identificador_serie']} do ensino fundamental 2</td>
                            <td>{$row['identificador_turma']}</td>
                            <td>{$dataCadastro}</td
                          </tr>";
                }
            } else {
                echo "<tr><td colspan='8' class='text-center'>Nenhum aluno encontrado</td></tr>";
            }
            ?>
        </tbody>
    </table>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

<?php
// Fechar conexão com o banco de dados
$conn->close();
?>
