<?php
// === Conexão com o banco (PDO) ===
$host = "localhost";
$user = "kaltekgo_admin";       
$pass = "kaltek@2024";          
$db   = "kaltekgo_avila";       

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Erro de conexão: " . $e->getMessage());
}


// === Buscar última atualização ===
$sqlData = "SELECT data_atualizacao 
              FROM calouros_veteranos 
          ORDER BY data_atualizacao DESC 
             LIMIT 1";
$stmt = $pdo->query($sqlData);
$ultimaAtualizacao = $stmt->fetchColumn();

// Se existir, formata a data
$dataFormatada = $ultimaAtualizacao 
    ? date("d/m/Y H:i", strtotime($ultimaAtualizacao)) 
    : "Sem registros";

/* ================== CONSULTAS ================== */

// Educação Infantil - Matutino
$sqledim = "SELECT v.sala_matriz, v.turma_nome AS turma, v.vagas_fisicas, v.ano_2025 AS ano_anterior, v.id,
    COUNT(c.turma) AS matriculados,
    SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END) AS veteranos,
    SUM(CASE WHEN c.calouro = 1 THEN 1 ELSE 0 END) AS novatos,
    (v.vagas_fisicas - COUNT(c.turma)) AS vagas_restantes,
    (v.ano_2025 - SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END)) AS vagas_reais
FROM vagas_series_turmas v
LEFT JOIN calouros_veteranos c ON v.turma_nome = c.turma
WHERE v.id BETWEEN 1 AND 10 AND v.turno = 'matutino'
GROUP BY v.sala_matriz, v.turma_nome, v.vagas_fisicas, v.ano_2025, v.id
ORDER BY v.id ASC";
$stmt = $pdo->query($sqledim);
$dadosedim = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Educação Infantil - Vespertino
$sqlediv = "SELECT v.sala_matriz, v.turma_nome AS turma, v.vagas_fisicas, v.ano_2025 AS ano_anterior, v.id,
    COUNT(c.turma) AS matriculados,
    SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END) AS veteranos,
    SUM(CASE WHEN c.calouro = 1 THEN 1 ELSE 0 END) AS novatos,
    (v.vagas_fisicas - COUNT(c.turma)) AS vagas_restantes,
    (v.ano_2025 - SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END)) AS vagas_reais
FROM vagas_series_turmas v
LEFT JOIN calouros_veteranos c ON v.turma_nome = c.turma
WHERE (v.turma_nome LIKE '%INFANTIL%')
  AND turno = 'vespertino'
GROUP BY v.sala_matriz, v.turma_nome, v.vagas_fisicas, v.ano_2025, v.id
ORDER BY v.id ASC";
$stmt = $pdo->query($sqlediv);
$dadosediv = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Fundamental I - Matutino
$sqlf1m = "SELECT v.sala_matriz, v.turma_nome AS turma, v.vagas_fisicas, v.ano_2025 AS ano_anterior, v.id,
    COUNT(c.turma) AS matriculados,
    SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END) AS veteranos,
    SUM(CASE WHEN c.calouro = 1 THEN 1 ELSE 0 END) AS novatos,
    (v.vagas_fisicas - COUNT(c.turma)) AS vagas_restantes,
    (v.ano_2025 - SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END)) AS vagas_reais
FROM vagas_series_turmas v
LEFT JOIN calouros_veteranos c ON v.turma_nome = c.turma
WHERE v.id  BETWEEN 11 AND 27 AND v.turno = 'matutino'
GROUP BY v.sala_matriz, v.turma_nome, v.vagas_fisicas, v.ano_2025, v.id
ORDER BY v.id ASC";
$stmt = $pdo->query($sqlf1m);
$dadosf1m = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Fundamental I - Vespertino
$sqlf1v = str_replace("matutino", "vespertino", $sqlf1m);
$stmt = $pdo->query($sqlf1v);
$dadosf1v = $stmt->fetchAll(PDO::FETCH_ASSOC);

// todas as salas
$sqlall = "SELECT v.sala_matriz, v.turma_nome AS turma, v.vagas_fisicas, v.ano_2025 AS ano_anterior, v.id,
    COUNT(c.turma) AS matriculados,
    SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END) AS veteranos,
    SUM(CASE WHEN c.calouro = 1 THEN 1 ELSE 0 END) AS novatos,
    (v.vagas_fisicas - COUNT(c.turma)) AS vagas_restantes,
    (v.ano_2025 - SUM(CASE WHEN c.veterano = 1 THEN 1 ELSE 0 END)) AS vagas_reais
FROM vagas_series_turmas v
LEFT JOIN calouros_veteranos c ON v.turma_nome = c.turma 
WHERE v.id BETWEEN 1 AND 27
GROUP BY v.sala_matriz, v.turma_nome, v.vagas_fisicas, v.ano_2025, v.id 
ORDER BY v.id ASC";
$stmt = $pdo->query($sqlall);
$dadosall = $stmt->fetchAll(PDO::FETCH_ASSOC);

/* ================== FUNÇÃO DA TABELA ================== */
function renderTabela($dados) {
    // Inicializa acumuladores
    $total_vagas_fisicas = 0;
    //$total_ano_anterior  = 0;
    $total_veteranos     = 0;
    $total_novatos       = 0;
    $total_matriculados  = 0;
    $total_vagas_rest    = 0;
    $total_vagas_reais   = 0;
    $total_vagas_esp     = 0;
    ?>
    <div class="table-responsive">
      <table class="table table-bordered table-striped">
        <thead>
          <tr>
            <th>Sala Matriz</th>
            <th>Série / Turma</th>
            <th>Vagas Físicas</th>
            <th>Ano Anterior - 2025</th>
            <th>Rematricula</th>
            <th>Novatos</th>
            <th>Matriculados</th>
            <th>Vagas Atuais</th>
            <th>Não rematricularam</th>
            <th>Vagas Esperadas</th>
          </tr>
        </thead>
        <tbody>
          <?php if ($dados): ?>
            <?php foreach ($dados as $row): ?>
              <?php
                $vagas_esp = $row['vagas_restantes'] - $row['vagas_reais'];
                // Somatórios
                $total_vagas_fisicas += $row['vagas_fisicas'];
                //$total_ano_anterior  += $row['ano_anterior'];
                $total_veteranos     += $row['veteranos'];
                $total_novatos       += $row['novatos'];
                $total_matriculados  += $row['matriculados'];
                $total_vagas_rest    += $row['vagas_restantes'];
                $total_vagas_reais   += $row['vagas_reais'];
                $total_vagas_esp     += $vagas_esp;
              ?>
              <tr>
                <td><?= htmlspecialchars($row['sala_matriz']) ?></td>
                <td><?= htmlspecialchars($row['turma']) ?></td>
                <td><?= htmlspecialchars($row['vagas_fisicas']) ?></td>
                <td><span data-toggle="tooltip" title="<?= htmlspecialchars($row['turma']) ?>"><?= htmlspecialchars($row['ano_anterior']) ?></td>
                <td><?= htmlspecialchars($row['veteranos']) ?></td>
                <td><?= htmlspecialchars($row['novatos']) ?></td>
                <td><?= htmlspecialchars($row['matriculados']) ?></td>
                <td><?= htmlspecialchars($row['vagas_restantes']) ?></td>
                <td><?= htmlspecialchars($row['vagas_reais']) ?></td>
                <td><?= htmlspecialchars($vagas_esp) ?></td>
              </tr>
            <?php endforeach; ?>
          <?php else: ?>
            <tr><td colspan="10" class="text-center">Nenhum registro encontrado.</td></tr>
          <?php endif; ?>
        </tbody>
        <?php if ($dados): ?>
        <tfoot>
          <tr style="font-weight: bold; background: #d9edf7;">
            <td colspan="2" class="text-right">TOTAL:</td>
            <td><?= $total_vagas_fisicas ?></td>
            <td><?= $total_ano_anterior ?></td>
            <td><?= $total_veteranos ?></td>
            <td><?= $total_novatos ?></td>
            <td><?= $total_matriculados ?></td>
            <td><?= $total_vagas_rest ?></td>
            <td><?= $total_vagas_reais ?></td>
            <td><?= $total_vagas_esp ?></td>
          </tr>
        </tfoot>
        <?php endif; ?>
      </table>
    </div>
    <?php
}


/* ================== INTERFACE ================== */
$data_atual = new DateTime();
$proximo_ano = $data_atual->modify('+1 year')->format('Y');
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta charset="UTF-8">
  <title>Relat&oacute;rio de alunos matriculados</title>
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
  <style>
     body {
      font-family: Arial, sans-serif;
      background-color: #ffffff;
      margin: 20px;
      color: #000000;
    }

    .container-fluid {
      width: 100%;
    }

    h4, h5 {
      margin: 0 0 10px;
    }

    table {
      white-space: nowrap;
      width: 100%;
      border-collapse: collapse;
      background-color: #ffffff;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
      text-transform: uppercase;
      min-width: auto;
    }

    th, td {
      padding: 12px 15px;
      text-align: left;
      font-size: 12px;
      border: 1px solid #000;
      vertical-align: middle !important;
    }

    th {
      background-color: #000;
      color: #fff;
    }

    tr:nth-child(even) {
      background-color: #f4f4f4;
    }

    tr:hover {
      background-color: #e0e0e0;
    }
    
    .table-container {
      max-height: 350px;   /* altura fixa */
      overflow-y: auto;    /* rolagem vertical */
      overflow-x: hidden;  /* evita rolagem horizontal */
    }

    .table thead th {
      position: sticky;    /* mantém cabeçalho fixo */
      top: 0;
      z-index: 2;
      background-color: #000; /* mantém cor do cabeçalho */
      color: #fff;
    }

    .total-box {
      margin-top: 5px;
      font-weight: bold;
      text-align: right;
    }
    
    
    @media (max-width: 768px) {
        .total-box {
      margin-top: 1px;
      font-weight: bold;
      text-align: right;
    }
    /* mantém a primeira coluna fixa durante rolagem horizontal */
.table-responsive {
  overflow-x: auto;
}

.table th:first-child,
.table td:first-child {
  position: sticky;
  left: 0;
  background-color: #fff;  /* mantém fundo */
  z-index: 3;              /* garante sobreposição */
  border-right: 1px solid #000; /* separador */
}

/* mantém alinhamento do cabeçalho da primeira coluna */
.table thead th:first-child {
  z-index: 4; 
  background-color: #000;
  color: #fff;
}

    
    }
  </style>
</head>
<body class="container-fluid">

  <h2 class="text-center text-uppercase">Relatorio de matr&iacute;culas <?= $proximo_ano ?></h2>
  <h5 class="text-right text-uppercase">Atualização: <?= $dataFormatada ?></h5>

  <!-- Menu de Abas -->
  <ul class="nav nav-tabs">
    <li class="active"><a data-toggle="tab" href="#edim">Educação Infantil - Matutino</a></li>
    <li><a data-toggle="tab" href="#ediv">Educação Infantil - Vespertino</a></li>
    <li><a data-toggle="tab" href="#f1m">Fundamental I - Matutino</a></li>
    <li><a data-toggle="tab" href="#f1v">Fundamental I - Vespertino</a></li>
    <li><a data-toggle="tab" href="#todas">Todas as Turmas</a></li>
  </ul>
<br>
  <!-- Conteúdo das Abas -->
  <div class="tab-content">
    <div id="edim" class="tab-pane fade in active">
      <h4 class="text-uppercase text-center">Educação Infantil - Matutino</h4>
      <?php renderTabela($dadosedim); ?>
    </div>
    <div id="ediv" class="tab-pane fade">
      <h4 class="text-uppercase text-center">Educação Infantil - Vespertino</h4>
      <?php renderTabela($dadosediv); ?>
    </div>
    <div id="f1m" class="tab-pane fade">
      <h4 class="text-uppercase text-center">Fundamental I - Matutino</h4>
      <?php renderTabela($dadosf1m); ?>
    </div>
    <div id="f1v" class="tab-pane fade">
      <h4 class="text-uppercase text-center">Fundamental I - Vespertino</h4>
      <?php renderTabela($dadosf1v); ?>
    </div>
    <div id="todas" class="tab-pane fade">
      <h4 class="text-uppercase text-center">Todas as Turmas</h4>
      <?php renderTabela($dadosall); ?>
    </div>
  </div>
  <?php
  
// somatoria dos matriculados
function somaMatriculados($dados) {
    $total = 0;
    foreach ($dados as $row) {
        $total += $row['matriculados'];
    }
    return $total;
}

// Totais por segmento
$total_ed_infantil = somaMatriculados($dadosedim) + somaMatriculados($dadosediv);
$total_fund1       = somaMatriculados($dadosf1m) + somaMatriculados($dadosf1v);


// Total geral
$total_geral = $total_ed_infantil + $total_fund1;
?>

<hr>
<div class="table-responsive">
  <table class="table table-bordered table-striped">
    <thead>
      <tr style="background:#000; color:#fff; text-transform:uppercase;">
        <th>Nível de Ensino</th>
        <th>Total de Alunos Matriculados</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td>Educação Infantil (Mat + Ves)</td>
        <td><?= $total_ed_infantil ?></td>
      </tr>
      <tr>
        <td>Fundamental I (Mat + Ves)</td>
        <td><?= $total_fund1 ?></td>
      </tr>
    </tbody>
    <tfoot>
      <tr style="font-weight:bold; background:#d9edf7;">
        <td>Total Geral</td>
        <td><?= $total_geral ?></td>
      </tr>
    </tfoot>
  </table>
</div>
<script>
$(function () {
  $('[data-toggle="tooltip"]').tooltip()
})
</script>

</body>
</html>
