<?php
header('Content-Type: application/json');

// === Conexão com o banco ===
$host = "localhost";
$user = "kaltekgo_admin";
$pass = "kaltek@2024";
$db   = "kaltekgo_avila";

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // 1) Novatos
    $sqlNovatos = "SELECT idUnidade, turma, COUNT(*) AS qtd
FROM calouros_veteranos
WHERE calouro = '1'
GROUP BY idUnidade, turma
ORDER BY idUnidade ASC,
         LEFT(turma, 1),
         CAST(SUBSTRING(turma, 2) AS UNSIGNED);

    ";
    $novatos = $pdo->query($sqlNovatos)->fetchAll(PDO::FETCH_ASSOC);
    $totalNovatos = array_sum(array_column($novatos, "qtd"));

    // 2) Veteranos
    $sqlVeteranos = "SELECT idUnidade, turma, COUNT(*) AS qtd
FROM calouros_veteranos
WHERE veterano = '1'
GROUP BY idUnidade, turma
ORDER BY idUnidade ASC,
         LEFT(turma, 1),
         CAST(SUBSTRING(turma, 2) AS UNSIGNED);

    ";
    $veteranos = $pdo->query($sqlVeteranos)->fetchAll(PDO::FETCH_ASSOC);
    $totalVeteranos = array_sum(array_column($veteranos, "qtd"));

    // 3) Total geral
    $sqlTotal = "
        SELECT idUnidade, turma, COUNT(*) as qtd 
        FROM calouros_veteranos 
        GROUP BY idUnidade, turma
        ORDER BY idUnidade ASC,
                 LEFT(turma,1), 
                 CAST(SUBSTRING(turma,2) AS UNSIGNED)
    ";
    $totais = $pdo->query($sqlTotal)->fetchAll(PDO::FETCH_ASSOC);
    $totalGeral = array_sum(array_column($totais, "qtd"));

    echo json_encode([
        "novatos" => $novatos,
        "totalNovatos" => $totalNovatos,
        "veteranos" => $veteranos,
        "totalVeteranos" => $totalVeteranos,
        "totais" => $totais,
        "totalGeral" => $totalGeral
    ]);
} catch (PDOException $e) {
    echo json_encode(["erro" => $e->getMessage()]);
}
