<?php
// Data atual
$data_atual = new DateTime();

// Adicionar um ano e formatar apenas o ano
$proximo_ano = $data_atual->modify('+1 year')->format('Y');
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta name="viewport" content="width=device-width, initial-scale=1"> <!-- importante para mobile -->
  <meta charset="UTF-8">
  <title>Relat&oacute;rio de alunos matriculados</title>
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <style>
    body {
      font-family: Arial, sans-serif;
      background-color: #ffffff;
      margin: 20px;
      color: #000000;
    }

    .container-fluid {
      width: 100%;
    }

    h4, h5 {
      margin: 0 0 10px;
    }

    table {
      white-space: nowrap;
      width: 100%;
      border-collapse: collapse;
      background-color: #ffffff;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
      text-transform: uppercase;
      min-width: auto;
    }

    th, td {
      padding: 12px 15px;
      text-align: left;
      font-size: 12px;
      border: 1px solid #000;
      vertical-align: middle !important;
    }

    th {
      background-color: #000;
      color: #fff;
    }

    tr:nth-child(even) {
      background-color: #f4f4f4;
    }

    tr:hover {
      background-color: #e0e0e0;
    }
    
    .table-container {
      max-height: 350px;   /* altura fixa */
      overflow-y: auto;    /* rolagem vertical */
      overflow-x: hidden;  /* evita rolagem horizontal */
      flex: 1;             /* ocupa todo o espa04o da coluna */
    }

    .table thead th {
      position: sticky;    /* mantm cabe04alho fixo */
      top: 0;
      z-index: 2;
      background-color: #000; /* mantm cor do cabe04alho */
      color: #fff;
    }

    .total-box {
      margin-top: 5px;
      font-weight: bold;
      text-align: right;
    }

    /* Alinhar colunas com a mesma altura */
    .row {
      display: flex;
      align-items: stretch;
    }

    .col-md-4 {
      display: flex;
      flex-direction: column;
    }

    /* No mobile volta ao empilhamento normal */
    @media (max-width: 768px) {
      .row {
        display: block;
      }
      .total-box {
        margin-top: 1px;
        text-align: right;
      }
    }
  </style>
</head>
<body class="container-fluid">

 <h2 class="text-center text-uppercase">
  Painel de alunos matriculados - ano <?php echo $proximo_ano; ?>
</h2>
<h5 class="text-right text-uppercase">
  &uacute;ltima atualiza&ccedil;&atilde;o: 14/09/2025 14:30
</h5>
  <hr>

  <div class="row">
    <div class="col-md-4">
      <h4 class="text-uppercase">Novatos</h4>
      <div class="table-container">
        <table class="table table-bordered table-striped" id="tabela-novatos">
          <thead>
            <tr><th>Sala</th><th>Quantidade</th></tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
      <div class="total-box" id="total-novatos"></div>
      <div class="total-box" id="total-novatos-ano-anterior"></div>
      <div class="total-box" id="total-novatos-diferenca"></div>
    </div>
    <br>
    <div class="col-md-4">
      <h4 class="text-uppercase">Veteranos</h4>
      <div class="table-container">
        <table class="table table-bordered table-striped" id="tabela-veteranos">
          <thead>
            <tr><th>Sala</th><th>Quantidade</th></tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
      <div class="total-box" id="total-veteranos"></div>
      <div class="total-box" id="total-veteranos-ano-anterior"></div>
      <div class="total-box" id="total-veteranos-diferenca"></div>
    </div>
    <br>
    <div class="col-md-4">
      <h4 class="text-uppercase">Total (Novatos e Veteranos)</h4>
      <div class="table-container">
        <table class="table table-bordered table-striped" id="tabela-totais">
          <thead>
            <tr><th>Sala</th><th>Total</th></tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
      <div class="total-box" id="total-geral"></div>
      <div class="total-box" id="total-geral-ano-anterior"></div>
      <div class="total-box" id="total-geral-diferenca"></div>
    </div>
  </div>

<script>
$(document).ready(function(){
    $.ajax({
        url: "get_dados.php",
        method: "GET",
        dataType: "json",
        success: function(data) {
            // Novatos
            $.each(data.novatos, function(i, item){
                $("#tabela-novatos tbody").append(
                    "<tr><td>"+item.turma+"</td><td>"+item.qtd+"</td></tr>"
                );
            });
            $("#total-novatos").html("Total: " + data.totalNovatos);
            $("#total-novatos-ano-anterior").html("Total novatos ano de 2025: 219");
            $("#total-novatos-diferenca").html("Diferen&ccedil;a: " + (219 - data.totalNovatos));

            // Veteranos
            $.each(data.veteranos, function(i, item){
                $("#tabela-veteranos tbody").append(
                    "<tr><td>"+item.turma+"</td><td>"+item.qtd+"</td></tr>"
                );
            });
            $("#total-veteranos").html("Total: " + data.totalVeteranos);
            $("#total-veteranos-ano-anterior").html("Total veteranos ano de 2025: 661");
            $("#total-veteranos-diferenca").html("Diferen&ccedil;a: " + (661 - data.totalVeteranos));

            // Totais
            $.each(data.totais, function(i, item){
                $("#tabela-totais tbody").append(
                    "<tr><td>"+item.turma+"</td><td>"+item.qtd+"</td></tr>"
                );
            });
            $("#total-geral").html("Total Geral: " + data.totalGeral);
            $("#total-geral-ano-anterior").html("Total ano de 2025: 880");
            $("#total-geral-diferenca").html("Diferen&ccedil;a: " + (880 - data.totalGeral));
        }
    });
});
</script>

</body>
</html>
