<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Logs de Conexão</title>

    <!-- Bootstrap 3 -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">

    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- Bootstrap JS -->
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

    <style>
        body {
            background: #f8f8f8;
            padding: 20px;
        }
        .panel-heading {
            font-weight: bold;
        }
        .table > tbody > tr > td {
            vertical-align: middle;
        }
    </style>
</head>
<body>
<div class="container">
    <div class="panel panel-default">
        <div class="panel-heading">📋 Logs de Falhas de Conexão</div>
        <div class="panel-body">
            <p>Últimos 50 registros de falhas nas conexões com <strong>PostgreSQL</strong> e <strong>MySQL</strong>.</p>
            <button id="atualizar" class="btn btn-primary btn-sm">
                Atualizar Logs
            </button>
        </div>

        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Banco</th>
                    <th>Mensagem</th>
                    <th>Data/Hora</th>
                </tr>
            </thead>
            <tbody id="logsTable">
                <tr>
                    <td colspan="4" class="text-center">Carregando logs...</td>
                </tr>
            </tbody>
        </table>
    </div>
</div>

<script>
function carregarLogs() {
    $.getJSON("logs.php", function(data) {
        let html = "";

        if (data.status === "ok" && data.total > 0) {
            $.each(data.logs, function(i, log) {
                html += `
                    <tr>
                        <td>${log.id}</td>
                        <td>${log.banco}</td>
                        <td>${log.mensagem}</td>
                        <td>${log.data_hora}</td>
                    </tr>
                `;
            });
        } else {
            html = `<tr><td colspan="4" class="text-center">Nenhum log encontrado</td></tr>`;
        }

        $("#logsTable").html(html);
    }).fail(function() {
        $("#logsTable").html(`<tr><td colspan="4" class="text-center text-danger">Erro ao carregar os logs</td></tr>`);
    });
}

// carregar automaticamente ao abrir
$(document).ready(function() {
    carregarLogs();

    // botão atualizar
    $("#atualizar").click(function() {
        carregarLogs();
    });

    // recarregar automaticamente a cada 60s
    setInterval(carregarLogs, 60000);
});
</script>
</body>
</html>
