<?php
header('Content-Type: application/json; charset=utf-8');

// ============================================
// Conexão com PostgreSQL
// ============================================
$host     = "179.185.67.60"; // seu host/IP
$port     = "5432";
$dbname   = "seibd";
$user     = "usr_leitura_avila";
$password = "j*mD+cJw";

try {
    $pdo = new PDO("pgsql:host=$host;port=$port;dbname=$dbname", $user, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo json_encode(["erro" => "Falha na conexão: " . $e->getMessage()]);
    exit;
}

// ============================================
// Query otimizada (CTE para veterano/novato)
// ============================================
$sql = "
WITH veterano_check AS (
    SELECT 
        m.aluno,
        mp.ano::INT AS ano
    FROM matricula m
    INNER JOIN matriculaperiodo mp ON mp.matricula = m.matricula
    WHERE mp.ano IS NOT NULL 
      AND mp.ano <> ''
      AND mp.situacaomatriculaperiodo IN ('AT','FI')
)
SELECT 
    ue.nome AS campo1,                  
    c.nome AS campo2,                   
    t.identificadorturma AS campo3,     
    ma.matricula AS campo4,             
    a.nome AS campo5,                   

    CASE WHEN v.aluno IS NULL THEN 1 ELSE 0 END AS campo6, -- Novato
    CASE WHEN v.aluno IS NOT NULL THEN 1 ELSE 0 END AS campo7, -- Veterano

    a.sexo AS campo8,                   
    ma.data AS campo9,                  

    c.nome AS agrupador1,
    ue.nome AS agrupador0

FROM matricula ma
INNER JOIN matriculaperiodo mp 
        ON mp.matricula = ma.matricula
INNER JOIN periodoletivo pl 
        ON mp.periodoletivomatricula = pl.codigo
INNER JOIN turma t 
        ON mp.turma = t.codigo
INNER JOIN unidadeensino ue 
        ON ue.codigo = ma.unidadeensino
INNER JOIN curso c 
        ON c.codigo = ma.curso
INNER JOIN turno tu 
        ON tu.codigo = ma.turno
INNER JOIN pessoa a 
        ON a.codigo = ma.aluno

LEFT JOIN veterano_check v 
       ON v.aluno = ma.aluno
      AND v.ano = (mp.ano::INT - 1)

WHERE ue.codigo IN (0, 6, 4, 3, 1)
  AND c.codigo IN (38, 5, 4, 1)
  AND mp.situacaomatriculaperiodo IN ('AT','TI','JU')
  AND mp.situacao IN ('CO','AT')
  AND tu.codigo IN (10, 5, 6)
  AND mp.ano = '2026'
  AND mp.ano IS NOT NULL 
  AND mp.ano <> ''

GROUP BY 
    ue.nome, c.nome, t.identificadorturma, 
    ma.matricula, a.nome, a.sexo, ma.data, v.aluno

ORDER BY 
    agrupador1, agrupador0, campo1 ASC, campo2 ASC, campo3 ASC, 
    campo5 ASC, campo8 ASC, campo9 ASC
";

// ============================================
// Execução e saída JSON
// ============================================
try {
    $stmt = $pdo->query($sql);
    $dados = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($dados, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
} catch (PDOException $e) {
    echo json_encode(["erro" => "Falha ao executar consulta: " . $e->getMessage()]);
}
?>